# 通知設計書 47-NOTIFICATION_WM_WINDOW_FOCUS_IN

## 概要

本ドキュメントは、Godotエンジンにおける `NOTIFICATION_WM_WINDOW_FOCUS_IN` 通知の設計仕様を記述する。この通知はWindow/MainLoop通知の一種であり、ウィンドウがフォーカスを取得した際に送信される。

### 本通知の処理概要

`NOTIFICATION_WM_WINDOW_FOCUS_IN` は、ゲームウィンドウがフォーカスを取得したことを通知するためのシステム通知である。ウィンドウマネージャー（WM）レベルのイベントを検知する。

**業務上の目的・背景**：ゲームやアプリケーションにおいて、ウィンドウがアクティブになった（フォーカスを取得した）ことを検知することで、適切なゲームロジックの制御が可能になる。例えば、フォーカス取得時にゲームを再開する、バックグラウンドで停止していた処理を再開する、オーディオをアンミュートする、入力処理を有効化するなどの処理が考えられる。マルチウィンドウ環境やウィンドウ切り替えが頻繁に行われるデスクトップ環境では特に重要な通知である。

**通知の送信タイミング**：DisplayServerからWINDOW_EVENT_FOCUS_INイベントを受信した時に送信される。具体的には、window.cppの824行目で`_propagate_window_notification(this, NOTIFICATION_WM_WINDOW_FOCUS_IN)`が呼び出される。また、ポップアップウィンドウを開く際に既存のウィンドウにFOCUS_OUTを送信するケース（2075行目）も存在する。

**通知の受信者**：Windowノードの子孫として存在するすべてのNodeノード。`_propagate_window_notification()`により、ウィンドウ内のノードツリー全体に伝播する。

**通知内容の概要**：整数値1004（NOTIFICATION_WM_WINDOW_FOCUS_IN）が通知される。追加のパラメータは含まれない。

**期待されるアクション**：受信したノードは、ウィンドウがフォーカスを取得したことに応じた処理を実行できる。例えば、ゲームの再開、オーディオの再生開始、入力処理の有効化などが考えられる。

## 通知種別

Godotエンジン内部通知（Window/MainLoop通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 通知値 | 1004 |
| 送信方式 | 同期（_propagate_window_notification） |
| 伝播方向 | ウィンドウ内の全ノードへ |
| 対象クラス | Nodeおよびその派生クラス |

### 送信先決定ロジック

`_propagate_window_notification()`メソッドにより、Windowノードの子孫すべてに通知が伝播する。すべてのNodeクラスが`_notification()`メソッドでこの通知を処理できる。

## 通知テンプレート

### 定数定義

| 項目 | 内容 |
|-----|------|
| 定義ファイル | scene/main/node.h |
| 定義行 | 479行目 |
| 定数名 | NOTIFICATION_WM_WINDOW_FOCUS_IN |
| 値 | 1004 |

### 使用例

```gdscript
func _notification(what):
    if what == NOTIFICATION_WM_WINDOW_FOCUS_IN:
        # ウィンドウがフォーカスを取得した時の処理
        _on_window_focus_gained()
```

```cpp
void CustomNode::_notification(int p_what) {
    switch (p_what) {
        case NOTIFICATION_WM_WINDOW_FOCUS_IN: {
            // ウィンドウがフォーカスを取得した時の処理
            _on_window_focus_gained();
        } break;
    }
}
```

## テンプレート変数

この通知には追加のパラメータは含まれない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_what | 通知種別（1004） | 直接渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| DisplayServerイベント | WINDOW_EVENT_FOCUS_IN | ウィンドウがフォーカスを取得した時 | OS/ウィンドウマネージャーからのイベント |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 該当なし | フォーカス取得時は常に送信される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[DisplayServer<br/>WINDOW_EVENT_FOCUS_IN] --> B[Window::_event_callback]
    B --> C[focused = true]
    C --> D[focused_window = this]
    D --> E[_propagate_window_notification<br/>WM_WINDOW_FOCUS_IN]
    E --> F[emit_signal<br/>focus_entered]
    F --> G{アクセシビリティ<br/>有効?}
    G -->|Yes| H[exclusive_child処理]
    G -->|No| I[終了]
    H --> I
```

## データベース参照・更新仕様

本通知はGodotエンジンの内部通知であり、データベースへのアクセスは行わない。

### 内部状態更新

| 状態変数 | 操作 | 備考 |
|---------|------|------|
| focused | true設定 | 822行目 |
| focused_window | this設定 | 823行目（静的変数） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | この通知は単純な状態変更通知のためエラーケースなし |

## 配信設定

### プラットフォーム対応

| プラットフォーム | 対応状況 | 備考 |
|----------------|---------|------|
| Windows | 対応 | ネイティブウィンドウイベント |
| macOS | 対応 | ネイティブウィンドウイベント |
| Linux | 対応 | X11/Wayland対応 |
| Web | 対応 | ブラウザのvisibilitychangeイベント等 |
| Android | 対応 | アクティビティのフォーカス |
| iOS | 対応 | アプリのフォアグラウンド遷移 |

## セキュリティ考慮事項

本通知はエンジン内部のウィンドウフォーカス管理に使用されるものであり、セキュリティ上の特別な考慮事項はない。

## 備考

- NOTIFICATION_WM_WINDOW_FOCUS_OUT（値=1005）と対になる通知
- `focus_entered`シグナルも同時に発信される
- アクセシビリティ機能が有効な場合、exclusive_childの処理も行われる
- focused_windowは静的変数で、現在フォーカスを持つウィンドウを追跡

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Nodeクラスの通知定数定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node.h | `scene/main/node.h` | 479行目: NOTIFICATION_WM_WINDOW_FOCUS_IN = 1004 の定義を確認 |

**読解のコツ**: Node.hのenum定義部分を参照し、NOTIFICATION_WM_WINDOW_FOCUS_OUT（1005）との関係を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるWindow::_event_callback()を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | window.cpp | `scene/main/window.cpp` | _event_callback()のWINDOW_EVENT_FOCUS_IN処理（821-835行目） |

**主要処理フロー**:
1. **822行目**: focused = true
2. **823行目**: focused_window = this
3. **824行目**: `_propagate_window_notification(this, NOTIFICATION_WM_WINDOW_FOCUS_IN)` の呼び出し
4. **825行目**: `emit_signal(focus_entered)` の呼び出し
5. **826-834行目**: アクセシビリティ処理

#### Step 3: 関連処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | window.cpp | `scene/main/window.cpp` | ポップアップ表示時のFOCUS_OUT送信（2070-2076行目） |

**主要処理フロー**:
- **2070-2076行目**: FLAG_POPUPが設定されたウィンドウを開く際に、他のビューポートにFOCUS_OUTを送信

### プログラム呼び出し階層図

```
DisplayServer
    │
    └─ Window::_event_callback(WINDOW_EVENT_FOCUS_IN)
           │
           ├─ focused = true
           │
           ├─ focused_window = this
           │
           ├─ _propagate_window_notification(NOTIFICATION_WM_WINDOW_FOCUS_IN)
           │      │
           │      └─ 全子孫Node::_notification(NOTIFICATION_WM_WINDOW_FOCUS_IN)
           │
           ├─ emit_signal(focus_entered)
           │
           └─ [アクセシビリティ処理] (条件付き)
                  └─ exclusive_childのフォーカス処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

DisplayServer ───▶ Window                      ───▶ 状態更新
WINDOW_EVENT         ::_event_callback()              + 通知伝播
FOCUS_IN                    │
                            ▼
                    状態更新 ───▶ focused = true
                            │       focused_window = this
                            ▼
                    _propagate_window_notification()
                            │
                            ▼
                    全子孫Nodeへ通知 ───▶ 各ノードの処理
                            │
                            ▼
                    emit_signal(focus_entered) ───▶ シグナルハンドラ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node.h | `scene/main/node.h` | ヘッダー | NOTIFICATION_WM_WINDOW_FOCUS_IN定数定義（479行目） |
| window.cpp | `scene/main/window.cpp` | ソース | _event_callback()での通知送信（824行目） |
| window.cpp | `scene/main/window.cpp` | ソース | ポップアップ時のFOCUS_OUT送信（2075行目） |
| display_server.h | `servers/display_server.h` | ヘッダー | WINDOW_EVENT_FOCUS_INイベント定義 |
