# 通知設計書 49-NOTIFICATION_WM_CLOSE_REQUEST

## 概要

本ドキュメントは、Godotエンジンにおける `NOTIFICATION_WM_CLOSE_REQUEST` 通知の設計仕様を記述する。この通知はWindow/MainLoop通知の一種であり、ユーザーがウィンドウを閉じようとした際に送信される。

### 本通知の処理概要

`NOTIFICATION_WM_CLOSE_REQUEST` は、ユーザーがウィンドウの閉じるボタン（×ボタン）をクリックした、またはAlt+F4などのショートカットでウィンドウを閉じようとしたことを通知するためのシステム通知である。

**業務上の目的・背景**：ゲームやアプリケーションにおいて、ユーザーがウィンドウを閉じようとした際に適切な終了処理を行う必要がある。例えば、未保存のデータがある場合に確認ダイアログを表示する、ゲームの状態を保存する、ネットワーク接続を適切に切断するなどの処理が考えられる。この通知を受け取ることで、アプリケーションは終了前のクリーンアップ処理や、終了をキャンセルするかどうかの判断を行える。デフォルトでは、この通知を受けるとアプリケーションは終了処理に入る。

**通知の送信タイミング**：DisplayServerからWINDOW_EVENT_CLOSE_REQUESTイベントを受信した時に送信される。具体的には、window.cppの850行目で`_propagate_window_notification(this, NOTIFICATION_WM_CLOSE_REQUEST)`が呼び出される。ただし、排他的な子ウィンドウ（exclusive_child）が存在する場合は、その子ウィンドウが閉じられるまで通知は送信されない。

**通知の受信者**：Windowノードの子孫として存在するすべてのNodeノード。`_propagate_window_notification()`により、ウィンドウ内のノードツリー全体に伝播する。

**通知内容の概要**：整数値1006（NOTIFICATION_WM_CLOSE_REQUEST）が通知される。追加のパラメータは含まれない。

**期待されるアクション**：受信したノードは、アプリケーション終了前の処理を実行できる。未保存データの確認、リソースの解放、終了のキャンセルなどが考えられる。デフォルトのSceneTree実装では、この通知を受けると`quit()`が呼び出されてアプリケーションが終了する。

## 通知種別

Godotエンジン内部通知（Window/MainLoop通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 通知値 | 1006 |
| 送信方式 | 同期（_propagate_window_notification） |
| 伝播方向 | ウィンドウ内の全ノードへ |
| 対象クラス | Nodeおよびその派生クラス |

### 送信先決定ロジック

`_propagate_window_notification()`メソッドにより、Windowノードの子孫すべてに通知が伝播する。すべてのNodeクラスが`_notification()`メソッドでこの通知を処理できる。排他的子ウィンドウがある場合は送信がブロックされる。

## 通知テンプレート

### 定数定義

| 項目 | 内容 |
|-----|------|
| 定義ファイル | scene/main/node.h |
| 定義行 | 481行目 |
| 定数名 | NOTIFICATION_WM_CLOSE_REQUEST |
| 値 | 1006 |

### 使用例

```gdscript
func _notification(what):
    if what == NOTIFICATION_WM_CLOSE_REQUEST:
        # ウィンドウを閉じるリクエストを受けた時の処理
        if has_unsaved_changes():
            show_save_confirmation_dialog()
            get_tree().set_quit_on_close_request(false)  # 自動終了を無効化
        else:
            get_tree().quit()
```

```cpp
void CustomNode::_notification(int p_what) {
    switch (p_what) {
        case NOTIFICATION_WM_CLOSE_REQUEST: {
            // ウィンドウを閉じるリクエストを受けた時の処理
            if (has_unsaved_changes()) {
                show_save_confirmation_dialog();
            }
        } break;
    }
}
```

## テンプレート変数

この通知には追加のパラメータは含まれない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_what | 通知種別（1006） | 直接渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| DisplayServerイベント | WINDOW_EVENT_CLOSE_REQUEST | ユーザーがウィンドウを閉じようとした時 | ×ボタン、Alt+F4など |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| exclusive_child != nullptr | 排他的子ウィンドウが存在する場合は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[DisplayServer<br/>WINDOW_EVENT_CLOSE_REQUEST] --> B[Window::_event_callback]
    B --> C{exclusive_child<br/>!= nullptr?}
    C -->|Yes| D[break - 送信スキップ]
    C -->|No| E[_propagate_window_notification<br/>WM_CLOSE_REQUEST]
    E --> F[emit_signal<br/>close_requested]
    F --> G[終了]
    D --> G
```

## データベース参照・更新仕様

本通知はGodotエンジンの内部通知であり、データベースへのアクセスは行わない。

### 関連処理

SceneTreeのデフォルト実装では、この通知を受けると以下の処理が実行される：

| 処理 | 内容 |
|-----|------|
| quit() | アプリケーションの終了処理を開始 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | この通知は単純なイベント通知のためエラーケースなし |

## 配信設定

### プラットフォーム対応

| プラットフォーム | 対応状況 | 備考 |
|----------------|---------|------|
| Windows | 対応 | ×ボタン、Alt+F4 |
| macOS | 対応 | ×ボタン、Cmd+Q |
| Linux | 対応 | ×ボタン、ウィンドウマネージャー依存 |
| Web | 条件付き | ブラウザタブを閉じる時（beforeunload） |
| Android | 限定的 | バックボタンはWM_GO_BACK_REQUESTで処理 |
| iOS | 限定的 | アプリ終了はOS管理 |

## セキュリティ考慮事項

本通知はエンジン内部のウィンドウ終了管理に使用されるものであり、セキュリティ上の特別な考慮事項はない。ただし、この通知を無視してアプリケーションの終了をブロックし続けることは、ユーザーエクスペリエンスの観点から推奨されない。

## 備考

- `close_requested`シグナルも同時に発信される
- `SceneTree.set_quit_on_close_request(false)`で自動終了を無効化可能
- 排他的子ウィンドウ（モーダルダイアログなど）がある場合は先にその子ウィンドウを閉じる必要がある
- MainLoopの`NOTIFICATION_WM_CLOSE_REQUEST`と同じ値を使用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Nodeクラスの通知定数定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node.h | `scene/main/node.h` | 481行目: NOTIFICATION_WM_CLOSE_REQUEST = 1006 の定義を確認 |

**読解のコツ**: Node.hのenum定義部分を参照し、他のWM系通知との関係を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるWindow::_event_callback()を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | window.cpp | `scene/main/window.cpp` | _event_callback()のWINDOW_EVENT_CLOSE_REQUEST処理（846-852行目） |

**主要処理フロー**:
1. **847-849行目**: exclusive_childチェック - 排他的子ウィンドウがあれば処理をスキップ
2. **850行目**: `_propagate_window_notification(this, NOTIFICATION_WM_CLOSE_REQUEST)` の呼び出し
3. **851行目**: `emit_signal(SNAME("close_requested"))` の呼び出し

#### Step 3: SceneTreeでの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scene_tree.cpp | `scene/main/scene_tree.cpp` | NOTIFICATION_WM_CLOSE_REQUESTのデフォルト処理 |

**主要処理フロー**:
- デフォルトでは`quit()`を呼び出してアプリケーションを終了

### プログラム呼び出し階層図

```
DisplayServer
    │
    └─ Window::_event_callback(WINDOW_EVENT_CLOSE_REQUEST)
           │
           ├─ [exclusive_childチェック]
           │      └─ exclusive_child != nullptr → break
           │
           ├─ _propagate_window_notification(NOTIFICATION_WM_CLOSE_REQUEST)
           │      │
           │      └─ 全子孫Node::_notification(NOTIFICATION_WM_CLOSE_REQUEST)
           │             │
           │             └─ SceneTree::_notification() → quit()
           │
           └─ emit_signal("close_requested")
```

### データフロー図

```
[入力]                    [処理]                         [出力]

×ボタンクリック ───▶ DisplayServer              ───▶ 通知伝播
Alt+F4               WINDOW_EVENT_CLOSE_REQUEST        + シグナル
                            │
                            ▼
                     Window::_event_callback()
                            │
                            ▼
                     exclusive_childチェック
                            │
                            ▼
                     _propagate_window_notification()
                            │
                            ▼
                     SceneTree処理 ───▶ quit() [デフォルト]
                            │
                            ▼
                     emit_signal("close_requested") ───▶ シグナルハンドラ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node.h | `scene/main/node.h` | ヘッダー | NOTIFICATION_WM_CLOSE_REQUEST定数定義（481行目） |
| window.cpp | `scene/main/window.cpp` | ソース | _event_callback()での通知送信（850行目） |
| scene_tree.cpp | `scene/main/scene_tree.cpp` | ソース | デフォルトの終了処理 |
| main_loop.h | `core/os/main_loop.h` | ヘッダー | MainLoop::NOTIFICATION_WM_CLOSE_REQUEST定義 |
| display_server.h | `servers/display_server.h` | ヘッダー | WINDOW_EVENT_CLOSE_REQUESTイベント定義 |
