# 通知設計書 50-NOTIFICATION_WM_GO_BACK_REQUEST

## 概要

本ドキュメントは、Godotエンジンにおける `NOTIFICATION_WM_GO_BACK_REQUEST` 通知の設計仕様を記述する。この通知はWindow/MainLoop通知の一種であり、主にAndroidデバイスでユーザーが「戻る」ボタンを押した際に送信される。

### 本通知の処理概要

`NOTIFICATION_WM_GO_BACK_REQUEST` は、ユーザーがモバイルデバイスの「戻る」ボタン（バックボタン）を押した、またはそれに相当する操作を行ったことを通知するためのシステム通知である。

**業務上の目的・背景**：Androidデバイスには物理的またはナビゲーションバー上の「戻る」ボタンがあり、ユーザーはこのボタンで前の画面に戻る、ダイアログを閉じる、メニューを閉じるなどの操作を期待する。この通知により、アプリケーションはAndroidのバックボタン操作に対して適切なナビゲーション処理を実装できる。デフォルトでは、この通知を受けるとアプリケーションは終了処理に入るが、カスタムハンドラを実装することで「前の画面に戻る」「ポップアップを閉じる」などの処理を行える。

**通知の送信タイミング**：DisplayServerからWINDOW_EVENT_GO_BACK_REQUESTイベントを受信した時に送信される。具体的には、window.cppの854行目で`_propagate_window_notification(this, NOTIFICATION_WM_GO_BACK_REQUEST)`が呼び出される。

**通知の受信者**：Windowノードの子孫として存在するすべてのNodeノード。`_propagate_window_notification()`により、ウィンドウ内のノードツリー全体に伝播する。

**通知内容の概要**：整数値1007（NOTIFICATION_WM_GO_BACK_REQUEST）が通知される。追加のパラメータは含まれない。

**期待されるアクション**：受信したノードは、「戻る」操作に対応する処理を実行できる。例えば、現在のシーンから前のシーンに戻る、開いているダイアログやメニューを閉じる、ゲーム内で一つ前の状態に戻るなどの処理が考えられる。デフォルトのSceneTree実装では、この通知を受けると`quit()`が呼び出されてアプリケーションが終了する。

## 通知種別

Godotエンジン内部通知（Window/MainLoop通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 通知値 | 1007 |
| 送信方式 | 同期（_propagate_window_notification） |
| 伝播方向 | ウィンドウ内の全ノードへ |
| 対象クラス | Nodeおよびその派生クラス |

### 送信先決定ロジック

`_propagate_window_notification()`メソッドにより、Windowノードの子孫すべてに通知が伝播する。すべてのNodeクラスが`_notification()`メソッドでこの通知を処理できる。

## 通知テンプレート

### 定数定義

| 項目 | 内容 |
|-----|------|
| 定義ファイル | scene/main/node.h |
| 定義行 | 482行目 |
| 定数名 | NOTIFICATION_WM_GO_BACK_REQUEST |
| 値 | 1007 |

### 使用例

```gdscript
func _notification(what):
    if what == NOTIFICATION_WM_GO_BACK_REQUEST:
        # Androidの戻るボタンが押された時の処理
        if current_scene_is_main_menu():
            # メインメニューなら終了確認を表示
            show_quit_confirmation()
        else:
            # それ以外なら前のシーンに戻る
            go_to_previous_scene()
```

```cpp
void CustomNode::_notification(int p_what) {
    switch (p_what) {
        case NOTIFICATION_WM_GO_BACK_REQUEST: {
            // Androidの戻るボタンが押された時の処理
            if (can_go_back()) {
                go_back();
            } else {
                close_current_popup();
            }
        } break;
    }
}
```

## テンプレート変数

この通知には追加のパラメータは含まれない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_what | 通知種別（1007） | 直接渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| DisplayServerイベント | WINDOW_EVENT_GO_BACK_REQUEST | ユーザーが「戻る」ボタンを押した時 | 主にAndroidのバックボタン |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 該当なし | 戻るボタン押下時は常に送信される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Androidバックボタン<br/>WINDOW_EVENT_GO_BACK_REQUEST] --> B[Window::_event_callback]
    B --> C[_propagate_window_notification<br/>WM_GO_BACK_REQUEST]
    C --> D[emit_signal<br/>go_back_requested]
    D --> E[終了]
```

## データベース参照・更新仕様

本通知はGodotエンジンの内部通知であり、データベースへのアクセスは行わない。

### 関連処理

SceneTreeのデフォルト実装では、この通知を受けると以下の処理が実行される：

| 処理 | 内容 |
|-----|------|
| quit() | アプリケーションの終了処理を開始（デフォルト） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | この通知は単純なイベント通知のためエラーケースなし |

## 配信設定

### プラットフォーム対応

| プラットフォーム | 対応状況 | 備考 |
|----------------|---------|------|
| Android | 対応 | 物理/ナビゲーションバーの戻るボタン |
| Windows | 非対応 | 相当する操作なし |
| macOS | 非対応 | 相当する操作なし |
| Linux | 非対応 | 相当する操作なし |
| Web | 条件付き | ブラウザの履歴API依存 |
| iOS | 限定的 | スワイプバックジェスチャー（システム管理） |

## セキュリティ考慮事項

本通知はエンジン内部のナビゲーション管理に使用されるものであり、セキュリティ上の特別な考慮事項はない。

## 備考

- `go_back_requested`シグナルも同時に発信される
- Androidアプリ開発では重要な通知
- デフォルトでは`quit()`が呼ばれるため、カスタムナビゲーションを実装する場合は早めにハンドリングする必要がある
- MainLoopの`NOTIFICATION_WM_GO_BACK_REQUEST`と同じ値を使用
- NOTIFICATION_WM_CLOSE_REQUEST（1006）と類似だが、用途が異なる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Nodeクラスの通知定数定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node.h | `scene/main/node.h` | 482行目: NOTIFICATION_WM_GO_BACK_REQUEST = 1007 の定義を確認 |

**読解のコツ**: Node.hのenum定義部分を参照し、NOTIFICATION_WM_CLOSE_REQUEST（1006）との違いを理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるWindow::_event_callback()を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | window.cpp | `scene/main/window.cpp` | _event_callback()のWINDOW_EVENT_GO_BACK_REQUEST処理（853-856行目） |

**主要処理フロー**:
1. **854行目**: `_propagate_window_notification(this, NOTIFICATION_WM_GO_BACK_REQUEST)` の呼び出し
2. **855行目**: `emit_signal(SNAME("go_back_requested"))` の呼び出し

#### Step 3: Android固有の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | display_server_android.cpp | `platform/android/display_server_android.cpp` | Androidでの戻るボタンイベント処理 |

### プログラム呼び出し階層図

```
Android OS / Navigation Bar
    │
    └─ DisplayServerAndroid
           │
           └─ Window::_event_callback(WINDOW_EVENT_GO_BACK_REQUEST)
                  │
                  ├─ _propagate_window_notification(NOTIFICATION_WM_GO_BACK_REQUEST)
                  │      │
                  │      └─ 全子孫Node::_notification(NOTIFICATION_WM_GO_BACK_REQUEST)
                  │             │
                  │             └─ [カスタムハンドラ] or SceneTree::quit()
                  │
                  └─ emit_signal("go_back_requested")
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Androidバックボタン ───▶ DisplayServer              ───▶ 通知伝播
                         WINDOW_EVENT_GO_BACK_REQUEST     + シグナル
                                │
                                ▼
                         Window::_event_callback()
                                │
                                ▼
                         _propagate_window_notification()
                                │
                                ▼
                         カスタムハンドラ ───▶ 画面遷移 / ポップアップ閉じ
                         or SceneTree ───▶ quit() [デフォルト]
                                │
                                ▼
                         emit_signal("go_back_requested") ───▶ シグナルハンドラ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node.h | `scene/main/node.h` | ヘッダー | NOTIFICATION_WM_GO_BACK_REQUEST定数定義（482行目） |
| window.cpp | `scene/main/window.cpp` | ソース | _event_callback()での通知送信（854行目） |
| scene_tree.cpp | `scene/main/scene_tree.cpp` | ソース | デフォルトの終了処理 |
| main_loop.h | `core/os/main_loop.h` | ヘッダー | MainLoop::NOTIFICATION_WM_GO_BACK_REQUEST定義 |
| display_server.h | `servers/display_server.h` | ヘッダー | WINDOW_EVENT_GO_BACK_REQUESTイベント定義 |
| display_server_android.cpp | `platform/android/display_server_android.cpp` | ソース | Android固有のバックボタン処理 |
