# 通知設計書 51-NOTIFICATION_WM_SIZE_CHANGED

## 概要

本ドキュメントは、Godotエンジンにおけるウィンドウサイズ変更時に発火するNOTIFICATION_WM_SIZE_CHANGED通知の設計仕様を定義する。

### 本通知の処理概要

NOTIFICATION_WM_SIZE_CHANGEDは、アプリケーションウィンドウのサイズが変更された際にWindowノードに対して送信されるシステム通知である。この通知により、ウィンドウサイズの変更をリアルタイムで検知し、UI要素のリサイズやレイアウト調整、ビューポートの再設定などの処理を実行することができる。

**業務上の目的・背景**：ゲームやアプリケーションにおいて、ユーザーがウィンドウサイズを変更した際に、表示内容を適切にスケーリングしたり、レイアウトを再配置したりする必要がある。特にデスクトッププラットフォームでは、リサイズ可能なウィンドウが一般的であり、レスポンシブなUI設計を実現するためにこの通知が不可欠である。

**通知の送信タイミング**：ウィンドウのサイズが変更された時点で発火する。具体的には、DisplayServerからWINDOW_EVENT_SIZE_CHANGEDイベントを受信した際、または`_update_viewport_size()`メソッドの処理完了後にWindowノードに対して通知が送信される。

**通知の受信者**：サイズが変更されたWindowノード自身のみが受信する。子ノードへの伝播は行われない（ドキュメントにて明記されている）。

**通知内容の概要**：通知値1008を持つ整数通知として送信される。追加のパラメータは含まれないが、受信時に`get_size()`メソッドを使用して新しいウィンドウサイズを取得できる。

**期待されるアクション**：受信者は新しいウィンドウサイズに基づいてUI要素の再配置、カメラのアスペクト比調整、レンダリングターゲットのリサイズなどを実行することが期待される。

## 通知種別

エンジン内部通知（Object._notification経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

サイズが変更されたWindowノード自身のみが受信対象となる。子ノードへの自動伝播は行われない。

## 通知テンプレート

### 通知定数定義

| 項目 | 内容 |
|-----|------|
| 定数名 | NOTIFICATION_WM_SIZE_CHANGED |
| 値 | 1008 |
| 定義場所 | scene/main/node.h |

### 受信処理例

```gdscript
func _notification(what):
    if what == NOTIFICATION_WM_SIZE_CHANGED:
        var new_size = get_window().size
        # サイズ変更に応じた処理を実行
        _on_window_resized(new_size)
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| window_size | 新しいウィンドウサイズ | Window.get_size() | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムイベント | DisplayServer::WINDOW_EVENT_SIZE_CHANGED | ウィンドウサイズ変更完了時 | OSからのサイズ変更イベント受信 |
| 内部処理 | _update_viewport_size()完了 | ビューポートサイズ更新完了時 | ビューポートサイズ変更処理後 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ウィンドウ非アクティブ | ウィンドウがシーンツリーに存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OSからサイズ変更イベント受信] --> B[DisplayServer::process_events]
    B --> C[Window::_event_callback]
    C --> D{イベント種別判定}
    D -->|SIZE_CHANGED| E[_update_viewport_size]
    E --> F[ビューポートリサイズ]
    F --> G[notification NOTIFICATION_WM_SIZE_CHANGED]
    G --> H[Windowノードが受信]
    H --> I[ユーザー定義処理実行]
    I --> J[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない内部通知）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ウィンドウ無効 | Windowノードが無効な状態で呼び出された場合 | 処理をスキップ |
| ビューポート未設定 | ビューポートが存在しない場合 | エラーログ出力後スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発火）

## セキュリティ考慮事項

特別な考慮事項なし。内部通知であり、外部からのアクセスは不可。

## 備考

- この通知はリサイズされたWindowノード自身のみが受信し、子ノードへは伝播されない
- デスクトッププラットフォーム（Windows、macOS、Linux）で実装されている
- ウィンドウのリサイズ中は頻繁に発火する可能性があるため、重い処理を直接実行することは推奨されない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知の定数値とその定義場所を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node.h | `scene/main/node.h` | NOTIFICATION_WM_SIZE_CHANGED = 1008 の定義（483行目） |
| 1-2 | main_loop.h | `core/os/main_loop.h` | 関連するMainLoop通知定数の定義 |

**読解のコツ**: Nodeクラスのenum定義を確認し、WM（Window Manager）関連の通知がどのように定義されているか確認する。

#### Step 2: エントリーポイントを理解する

通知の発火元となるWindowクラスの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | window.cpp | `scene/main/window.cpp` | notification(NOTIFICATION_WM_SIZE_CHANGED)の呼び出し箇所（1339行目） |

**主要処理フロー**:
1. **1339行目**: `notification(NOTIFICATION_WM_SIZE_CHANGED)` - ビューポートサイズ更新後に通知を発火

#### Step 3: ビューポートサイズ更新処理を理解する

_update_viewport_size()メソッドの詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | window.cpp | `scene/main/window.cpp` | _update_viewport_size()メソッドの実装 |

**主要処理フロー**:
- ビューポートのサイズ計算
- RenderingServerへのビューポートアタッチ処理
- NOTIFICATION_WM_SIZE_CHANGED通知の発火

### プログラム呼び出し階層図

```
DisplayServer (OS)
    │
    ├─ Window::_event_callback()
    │      │
    │      └─ WINDOW_EVENT_SIZE_CHANGED イベント
    │             │
    │             └─ _update_viewport_size()
    │                    │
    │                    └─ notification(NOTIFICATION_WM_SIZE_CHANGED)
    │                           │
    │                           └─ Node::_notification() [ユーザーオーバーライド可能]
    │
    └─ 埋め込みウィンドウサイズ変更
           │
           └─ Viewport::set_oversampling_override()
```

### データフロー図

```
[入力]               [処理]                    [出力]

OSサイズ変更      DisplayServer           Window通知
イベント    ───▶ イベント処理   ───▶    発火
                      │
                      ▼
              ビューポートサイズ
                  更新処理
                      │
                      ▼
              RenderingServer
                リサイズ処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node.h | `scene/main/node.h` | ソース | 通知定数の定義 |
| node.cpp | `scene/main/node.cpp` | ソース | Nodeベースクラスの通知処理 |
| window.cpp | `scene/main/window.cpp` | ソース | Window通知の発火処理 |
| window.h | `scene/main/window.h` | ソース | Windowクラス定義 |
| dialogs.cpp | `scene/gui/dialogs.cpp` | ソース | ダイアログでのサイズ変更対応 |
| popup.cpp | `scene/gui/popup.cpp` | ソース | ポップアップでのサイズ変更対応 |
| popup_menu.cpp | `scene/gui/popup_menu.cpp` | ソース | ポップアップメニューでのサイズ変更対応 |
| Node.xml | `doc/classes/Node.xml` | ドキュメント | 通知の公式ドキュメント |
