# 通知設計書 53-NOTIFICATION_OS_MEMORY_WARNING

## 概要

本ドキュメントは、GodotエンジンにおけるOSからのメモリ警告時に発火するNOTIFICATION_OS_MEMORY_WARNING通知の設計仕様を定義する。

### 本通知の処理概要

NOTIFICATION_OS_MEMORY_WARNINGは、オペレーティングシステムからアプリケーションがメモリを過剰に使用しているという警告を受信した際に発火するシステム通知である。この通知により、アプリケーションはメモリ使用量を削減するための緊急対応（キャッシュのクリア、未使用リソースの解放など）を実行することができる。

**業務上の目的・背景**：モバイルプラットフォーム（特にiOSおよびAndroid）では、システムメモリが逼迫した場合にOSがアプリケーションを強制終了する可能性がある。この通知を適切に処理することで、アプリケーションのクラッシュを防ぎ、ユーザー体験を向上させることができる。メモリ管理が厳格なモバイル環境では、この通知への対応が特に重要である。

**通知の送信タイミング**：OSがメモリ不足状態を検知し、アプリケーションにメモリ解放を要求した時点で発火する。iOSではdidReceiveMemoryWarning、AndroidではonLowMemoryに相当する。

**通知の受信者**：SceneTreeのルートノードから全ての子ノードに対して`propagate_notification`を通じて伝播される。

**通知内容の概要**：通知値2009を持つ整数通知として送信される。追加のパラメータは含まれない。

**期待されるアクション**：受信者はキャッシュされたリソースの解放、未使用テクスチャのアンロード、一時データの削除など、メモリ使用量を削減するための処理を実行することが期待される。

## 通知種別

エンジン内部通知（Object._notification経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 最高（緊急） |
| リトライ | なし |

### 送信先決定ロジック

SceneTree::notify_group_flags()を通じてルートノードから全ての子ノードに伝播される。

## 通知テンプレート

### 通知定数定義

| 項目 | 内容 |
|-----|------|
| 定数名 | NOTIFICATION_OS_MEMORY_WARNING |
| 値 | 2009 |
| 定義場所 | core/os/main_loop.h（Nodeで再定義） |

### 受信処理例

```gdscript
func _notification(what):
    if what == NOTIFICATION_OS_MEMORY_WARNING:
        # キャッシュをクリア
        _clear_resource_cache()
        # 未使用リソースを解放
        ResourceLoader.clear_cache()
        # ガベージコレクションを促す
        print("Memory warning received - clearing caches")
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 追加パラメータなし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| OSイベント | iOS didReceiveMemoryWarning | メモリ不足検知 | iOSシステムからのメモリ警告 |
| OSイベント | Android onLowMemory | メモリ不足検知 | Androidシステムからのメモリ警告 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| SceneTree未初期化 | ルートノードが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OSからメモリ警告受信] --> B[プラットフォーム固有ハンドラ]
    B --> C[MainLoop::notification]
    C --> D[SceneTree::_notification]
    D --> E{ルートノード存在?}
    E -->|Yes| F[get_root->propagate_notification]
    F --> G[全ノードへ通知伝播]
    G --> H[各ノードでメモリ解放処理]
    H --> I[終了]
    E -->|No| I
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない内部通知）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ルートノード未存在 | SceneTreeが初期化されていない場合 | 通知をスキップ |
| メモリ解放失敗 | リソースがロックされている場合 | ログ出力して継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（OS依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（OSからの警告に応じて随時発火）

## セキュリティ考慮事項

特別な考慮事項なし。内部通知であり、外部からのアクセスは不可。

## 備考

- iOSおよびAndroidプラットフォームで実装されている
- この通知を無視すると、OSによるアプリケーションの強制終了のリスクがある
- 公式ドキュメントではiOS固有とされているが、Androidでも実装されている
- メモリ解放処理は可能な限り高速に完了すべき

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知の定数値とその定義場所を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main_loop.h | `core/os/main_loop.h` | NOTIFICATION_OS_MEMORY_WARNING = 2009 の定義（50行目） |
| 1-2 | node.h | `scene/main/node.h` | Nodeクラスでの再定義（489行目） |

**読解のコツ**: MainLoopで定義された通知定数がNodeクラスで再定義されていることを確認する。

#### Step 2: 通知伝播処理を理解する

SceneTreeでの通知処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scene_tree.cpp | `scene/main/scene_tree.cpp` | _notification()メソッドでのNOTIFICATION_OS_MEMORY_WARNING処理（911-920行目） |

**主要処理フロー**:
1. **911行目**: `case NOTIFICATION_OS_MEMORY_WARNING:` - メモリ警告ケースの判定
2. **920行目**: `get_root()->propagate_notification(p_notification)` - ルートから全ノードへ伝播

#### Step 3: プラットフォーム固有実装を理解する

iOSおよびAndroidでの発火元を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | app_delegate_service.mm | `drivers/apple_embedded/app_delegate_service.mm` | iOS側のメモリ警告ハンドラ |

### プログラム呼び出し階層図

```
OS (iOS/Android)
    │
    ├─ [iOS] AppDelegate didReceiveMemoryWarning
    │      │
    │      └─ MainLoop::notification(NOTIFICATION_OS_MEMORY_WARNING)
    │
    ├─ [Android] GodotLib.onLowMemory
    │      │
    │      └─ MainLoop::notification(NOTIFICATION_OS_MEMORY_WARNING)
    │
    └─ SceneTree::_notification()
           │
           └─ get_root()->propagate_notification()
                  │
                  └─ 全Node::_notification() [再帰的に伝播]
```

### データフロー図

```
[入力]               [処理]                    [出力]

OSメモリ警告   プラットフォーム          SceneTree
イベント    ───▶ ハンドラ      ───▶    通知発火
                      │
                      ▼
                MainLoop
              notification()
                      │
                      ▼
              SceneTree
              _notification()
                      │
                      ▼
              全ノードへ伝播
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main_loop.h | `core/os/main_loop.h` | ソース | 通知定数の定義 |
| main_loop.cpp | `core/os/main_loop.cpp` | ソース | MainLoopの通知バインド |
| node.h | `scene/main/node.h` | ソース | Nodeクラスでの通知定数再定義 |
| scene_tree.cpp | `scene/main/scene_tree.cpp` | ソース | 通知の伝播処理 |
| app_delegate_service.mm | `drivers/apple_embedded/app_delegate_service.mm` | ソース | iOS側メモリ警告ハンドラ |
| MainLoop.xml | `doc/classes/MainLoop.xml` | ドキュメント | 通知の公式ドキュメント |
| Node.xml | `doc/classes/Node.xml` | ドキュメント | Nodeでの通知説明 |
