# 通知設計書 54-NOTIFICATION_TRANSLATION_CHANGED

## 概要

本ドキュメントは、Godotエンジンにおける翻訳/ロケール変更時に発火するNOTIFICATION_TRANSLATION_CHANGED通知の設計仕様を定義する。

### 本通知の処理概要

NOTIFICATION_TRANSLATION_CHANGEDは、アプリケーションの翻訳設定やロケール設定が変更された際に発火するシステム通知である。この通知により、UIテキスト、ラベル、ボタンなどの表示言語をリアルタイムで切り替え、国際化対応を実現することができる。

**業務上の目的・背景**：多言語対応アプリケーションにおいて、ユーザーが言語設定を変更した際に、即座にUI全体の言語を切り替える必要がある。この通知を利用することで、ノードベースの階層構造に沿って全てのUIコンポーネントに翻訳変更を通知し、統一された言語切り替え体験を提供できる。Godotの組み込み翻訳サポート（tr()メソッド）と連携して動作する。

**通知の送信タイミング**：TranslationServer.set_locale()が呼び出された時、またはノードがシーンツリーに追加されてauto_translate_modeが有効な場合（POST_ENTER_TREE時）に発火する。

**通知の受信者**：SceneTreeのルートノードから全ての子ノードに対して`propagate_notification`を通じて伝播される。auto_translate_modeが無効なノードでは通知が処理されない場合がある。

**通知内容の概要**：通知値2010を持つ整数通知として送信される。追加のパラメータは含まれない。

**期待されるアクション**：受信者はtr()メソッドを使用してUIテキストを再取得し、表示を更新することが期待される。多くのGUIコントロール（Label、Button、RichTextLabelなど）は自動的にテキストを再描画する。

## 通知種別

エンジン内部通知（Object._notification経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

SceneTree::_notification()で受信後、get_root()->propagate_notification()を通じてルートノードから全ての子ノードに伝播される。

## 通知テンプレート

### 通知定数定義

| 項目 | 内容 |
|-----|------|
| 定数名 | NOTIFICATION_TRANSLATION_CHANGED |
| 値 | 2010 |
| 定義場所 | core/os/main_loop.h（Nodeで再定義） |

### 受信処理例

```gdscript
func _notification(what):
    if what == NOTIFICATION_TRANSLATION_CHANGED:
        # 翻訳テキストを再取得して更新
        $Label.text = tr("HELLO_WORLD")
        $Button.text = tr("SUBMIT_BUTTON")
        # カスタムUI要素の更新
        _update_localized_ui()
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| locale | 現在のロケール | TranslationServer.get_locale() | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | TranslationServer.set_locale() | ロケール変更時 | ユーザーによるロケール変更 |
| ノードライフサイクル | NOTIFICATION_POST_ENTER_TREE | auto_translate_mode有効時 | ノード追加時の初期翻訳適用 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| auto_translate_mode無効 | ノードのauto_translate_modeがDISABLEDの場合 |
| SceneTree未初期化 | ルートノードが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[TranslationServer.set_locale呼び出し] --> B[ロケール変更処理]
    B --> C[MainLoop::notification発火]
    C --> D[SceneTree::_notification]
    D --> E{ルートノード存在?}
    E -->|Yes| F[get_root->propagate_notification]
    F --> G[全ノードへ通知伝播]
    G --> H{auto_translate_mode確認}
    H -->|DISABLED以外| I[UIテキスト再取得・更新]
    H -->|DISABLED| J[処理スキップ]
    I --> K[終了]
    J --> K
    E -->|No| K
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない内部通知）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 翻訳キー未定義 | tr()に存在しないキーが渡された場合 | キー名をそのまま返却 |
| ルートノード未存在 | SceneTreeが初期化されていない場合 | 通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ロケール変更に応じて随時発火）

## セキュリティ考慮事項

特別な考慮事項なし。内部通知であり、外部からのアクセスは不可。

## 備考

- 多くのGUIノード（Control派生クラス）は自動的にこの通知を処理してテキストを再描画する
- auto_translate_modeプロパティでノード単位の翻訳挙動を制御可能
- 組み込み翻訳サポート（tr()メソッド）と連携して動作する
- POST_ENTER_TREE時にも発火するため、ノード追加時に適切な翻訳が適用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知の定数値とその定義場所を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main_loop.h | `core/os/main_loop.h` | NOTIFICATION_TRANSLATION_CHANGED = 2010 の定義（51行目） |
| 1-2 | node.h | `scene/main/node.h` | Nodeクラスでの再定義（490行目） |

**読解のコツ**: MainLoopで定義された通知定数がNodeクラスで再定義されていることを確認する。

#### Step 2: 通知発火処理を理解する

TranslationServerでの通知発火を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | translation_server.cpp | `core/string/translation_server.cpp` | set_locale()メソッドでの通知発火 |

**主要処理フロー**:
1. set_locale()でロケール設定を変更
2. MainLoopに対してNOTIFICATION_TRANSLATION_CHANGED通知を発火

#### Step 3: 通知伝播処理を理解する

SceneTreeでの通知処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scene_tree.cpp | `scene/main/scene_tree.cpp` | _notification()メソッドでのNOTIFICATION_TRANSLATION_CHANGED処理（907-908行目） |

**主要処理フロー**:
1. **907行目**: `case NOTIFICATION_TRANSLATION_CHANGED:` - 翻訳変更ケースの判定
2. **908行目**: `get_root()->propagate_notification(p_notification)` - ルートから全ノードへ伝播

#### Step 4: ノードでの受信処理を理解する

Nodeクラスでの通知受信処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | node.cpp | `scene/main/node.cpp` | POST_ENTER_TREE時のTRANSLATION_CHANGED通知発火（180-183行目） |

### プログラム呼び出し階層図

```
TranslationServer.set_locale()
    │
    └─ MainLoop::notification(NOTIFICATION_TRANSLATION_CHANGED)
           │
           └─ SceneTree::_notification()
                  │
                  └─ get_root()->propagate_notification()
                         │
                         ├─ Node::_notification() [再帰的に伝播]
                         │
                         └─ Control::_notification() [UIテキスト再描画]
                                │
                                ├─ Label::_notification()
                                ├─ Button::_notification()
                                └─ その他GUI系ノード
```

### データフロー図

```
[入力]               [処理]                    [出力]

set_locale()    TranslationServer       MainLoop通知
呼び出し    ───▶ ロケール変更   ───▶    発火
                      │
                      ▼
                SceneTree
              _notification()
                      │
                      ▼
              全ノードへ伝播
                      │
                      ▼
              UIテキスト再描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main_loop.h | `core/os/main_loop.h` | ソース | 通知定数の定義 |
| main_loop.cpp | `core/os/main_loop.cpp` | ソース | MainLoopの通知バインド |
| node.h | `scene/main/node.h` | ソース | Nodeクラスでの通知定数再定義 |
| node.cpp | `scene/main/node.cpp` | ソース | ノードでの通知受信処理 |
| scene_tree.cpp | `scene/main/scene_tree.cpp` | ソース | 通知の伝播処理 |
| translation_server.cpp | `core/string/translation_server.cpp` | ソース | ロケール変更時の通知発火 |
| control.cpp | `scene/gui/control.cpp` | ソース | GUI要素での通知処理 |
| label.cpp | `scene/gui/label.cpp` | ソース | Labelの翻訳更新処理 |
| button.cpp | `scene/gui/button.cpp` | ソース | Buttonの翻訳更新処理 |
| MainLoop.xml | `doc/classes/MainLoop.xml` | ドキュメント | 通知の公式ドキュメント |
