# 通知設計書 55-NOTIFICATION_WM_ABOUT

## 概要

本ドキュメントは、Godotエンジンにおける「About」情報要求時に発火するNOTIFICATION_WM_ABOUT通知の設計仕様を定義する。

### 本通知の処理概要

NOTIFICATION_WM_ABOUTは、macOSプラットフォームにおいてアプリケーションメニューから「About」（このアプリについて）項目が選択された際に発火するシステム通知である。この通知により、アプリケーション固有のバージョン情報ダイアログや著作権情報を表示することができる。

**業務上の目的・背景**：macOSアプリケーションの標準的なUI規約では、アプリケーションメニューに「About [アプリ名]」という項目を配置し、ユーザーがアプリケーションのバージョン情報や著作権情報を確認できるようにすることが求められている。この通知を利用することで、Godotアプリケーションもこの規約に準拠したユーザー体験を提供できる。

**通知の送信タイミング**：macOSのアプリケーションデリゲートがapplicationShouldHandleReopenイベントを受信した際、またはメニューバーの「About」項目が選択された際に発火する。

**通知の受信者**：SceneTreeのルートノードから全ての子ノードに対して`propagate_notification`を通じて伝播される。

**通知内容の概要**：通知値2011を持つ整数通知として送信される。追加のパラメータは含まれない。

**期待されるアクション**：受信者はカスタムの「About」ダイアログを表示するか、アプリケーション情報を表示するための処理を実行することが期待される。処理しない場合は、OSのデフォルト動作が適用される場合がある。

## 通知種別

エンジン内部通知（Object._notification経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

SceneTree::_notification()で受信後、get_root()->propagate_notification()を通じてルートノードから全ての子ノードに伝播される。

## 通知テンプレート

### 通知定数定義

| 項目 | 内容 |
|-----|------|
| 定数名 | NOTIFICATION_WM_ABOUT |
| 値 | 2011 |
| 定義場所 | core/os/main_loop.h（Nodeで再定義） |

### 受信処理例

```gdscript
func _notification(what):
    if what == NOTIFICATION_WM_ABOUT:
        # カスタムAboutダイアログを表示
        _show_about_dialog()

func _show_about_dialog():
    var dialog = AcceptDialog.new()
    dialog.title = "About My Game"
    dialog.dialog_text = "My Game v1.0.0\nCopyright 2024 My Company"
    add_child(dialog)
    dialog.popup_centered()
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 追加パラメータなし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| OSイベント | macOS About menu選択 | メニュー項目選択時 | アプリケーションメニューからの選択 |
| OSイベント | Dock icon click（アプリ起動中） | アプリケーション再オープン時 | macOS Dockアイコンクリック |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非macOSプラットフォーム | macOS以外では発火しない |
| SceneTree未初期化 | ルートノードが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[macOS About メニュー選択] --> B[GodotApplicationDelegate]
    B --> C[MainLoop::notification発火]
    C --> D[SceneTree::_notification]
    D --> E{ルートノード存在?}
    E -->|Yes| F[get_root->propagate_notification]
    F --> G[全ノードへ通知伝播]
    G --> H[カスタムAboutダイアログ表示]
    H --> I[終了]
    E -->|No| I
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない内部通知）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ルートノード未存在 | SceneTreeが初期化されていない場合 | 通知をスキップ |
| ダイアログ表示失敗 | ウィンドウシステムエラー | ログ出力して継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発火）

## セキュリティ考慮事項

特別な考慮事項なし。内部通知であり、外部からのアクセスは不可。

## 備考

- macOSプラットフォームでのみ実装されている
- Godotエディタではこの通知を使用してAboutダイアログを表示している
- プロジェクトマネージャーでも使用されている
- 処理しない場合のデフォルト動作はプラットフォーム依存

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知の定数値とその定義場所を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main_loop.h | `core/os/main_loop.h` | NOTIFICATION_WM_ABOUT = 2011 の定義（52行目） |
| 1-2 | node.h | `scene/main/node.h` | Nodeクラスでの再定義（491行目） |

**読解のコツ**: MainLoopで定義された通知定数がNodeクラスで再定義されていることを確認する。

#### Step 2: プラットフォーム固有実装を理解する

macOS固有のアプリケーションデリゲート実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | godot_application_delegate.mm | `platform/macos/godot_application_delegate.mm` | macOSアプリケーションデリゲートの実装 |

**主要処理フロー**:
1. macOSのAboutメニュー選択を検知
2. MainLoopに対してNOTIFICATION_WM_ABOUT通知を発火

#### Step 3: 通知伝播処理を理解する

SceneTreeでの通知処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scene_tree.cpp | `scene/main/scene_tree.cpp` | _notification()メソッドでのNOTIFICATION_WM_ABOUT処理（913行目） |

**主要処理フロー**:
1. **913行目**: `case NOTIFICATION_WM_ABOUT:` - Aboutケースの判定
2. **920行目**: `get_root()->propagate_notification(p_notification)` - ルートから全ノードへ伝播

#### Step 4: エディタでの使用例を理解する

Godotエディタでのこの通知の使用例を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | editor_node.cpp | `editor/editor_node.cpp` | エディタでのAboutダイアログ処理 |
| 4-2 | project_manager.cpp | `editor/project_manager/project_manager.cpp` | プロジェクトマネージャーでの使用 |

### プログラム呼び出し階層図

```
macOS Application Menu
    │
    ├─ "About [App Name]" menu item
    │      │
    │      └─ GodotApplicationDelegate
    │             │
    │             └─ MainLoop::notification(NOTIFICATION_WM_ABOUT)
    │
    └─ SceneTree::_notification()
           │
           └─ get_root()->propagate_notification()
                  │
                  └─ Node::_notification() [再帰的に伝播]
                         │
                         └─ カスタムAboutダイアログ表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

macOS About    GodotApplication          MainLoop通知
メニュー   ───▶ Delegate       ───▶      発火
                      │
                      ▼
                SceneTree
              _notification()
                      │
                      ▼
              全ノードへ伝播
                      │
                      ▼
              Aboutダイアログ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main_loop.h | `core/os/main_loop.h` | ソース | 通知定数の定義 |
| main_loop.cpp | `core/os/main_loop.cpp` | ソース | MainLoopの通知バインド |
| node.h | `scene/main/node.h` | ソース | Nodeクラスでの通知定数再定義 |
| scene_tree.cpp | `scene/main/scene_tree.cpp` | ソース | 通知の伝播処理 |
| godot_application_delegate.mm | `platform/macos/godot_application_delegate.mm` | ソース | macOS固有のイベントハンドラ |
| editor_node.cpp | `editor/editor_node.cpp` | ソース | エディタでの使用例 |
| project_manager.cpp | `editor/project_manager/project_manager.cpp` | ソース | プロジェクトマネージャーでの使用例 |
| MainLoop.xml | `doc/classes/MainLoop.xml` | ドキュメント | 通知の公式ドキュメント |
