# 通知設計書 58-NOTIFICATION_APPLICATION_RESUMED

## 概要

本ドキュメントは、Godotエンジンにおけるアプリケーションがフォアグラウンドに復帰した際に発火するNOTIFICATION_APPLICATION_RESUMED通知の設計仕様を定義する。

### 本通知の処理概要

NOTIFICATION_APPLICATION_RESUMEDは、モバイルプラットフォーム（AndroidおよびiOS）においてアプリケーションがバックグラウンドからフォアグラウンドに復帰した際に発火するシステム通知である。この通知により、一時停止されていたゲームロジックの再開、オーディオの復帰、ネットワーク接続の再確立などを実行することができる。

**業務上の目的・背景**：モバイルアプリケーションでは、ユーザーがホームボタンを押したり、他のアプリに切り替えたりするとアプリケーションがバックグラウンドに移行する。再びアプリに戻った際に、ゲーム状態を適切に復帰させ、シームレスなユーザー体験を提供する必要がある。特にゲームではBGMの再開やアニメーションの再開が重要となる。

**通知の送信タイミング**：アプリケーションがバックグラウンドからフォアグラウンドに復帰した時点で発火する。AndroidではonResume()、iOSではapplicationDidBecomeActive:に相当する。

**通知の受信者**：SceneTreeのルートノードから全ての子ノードに対して`propagate_notification`を通じて伝播される。

**通知内容の概要**：通知値2014を持つ整数通知として送信される。追加のパラメータは含まれない。

**期待されるアクション**：受信者はバックグラウンド移行時に一時停止した処理を再開することが期待される。具体的にはオーディオ再生の再開、ゲームロジックの復帰、サーバーとの再接続などが挙げられる。

## 通知種別

エンジン内部通知（Object._notification経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

SceneTree::_notification()で受信後、get_root()->propagate_notification()を通じてルートノードから全ての子ノードに伝播される。

## 通知テンプレート

### 通知定数定義

| 項目 | 内容 |
|-----|------|
| 定数名 | NOTIFICATION_APPLICATION_RESUMED |
| 値 | 2014 |
| 定義場所 | core/os/main_loop.h（Nodeで再定義） |

### 受信処理例

```gdscript
func _notification(what):
    if what == NOTIFICATION_APPLICATION_RESUMED:
        # アプリ復帰時の処理
        _on_app_resumed()

func _on_app_resumed():
    # BGMを再開
    $BGMPlayer.play()
    # ゲームを再開
    get_tree().paused = false
    # サーバーとの接続を確認
    _check_server_connection()
    print("Application resumed from background")
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 追加パラメータなし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| OSイベント | Android onResume() | アプリがフォアグラウンドに復帰 | Androidライフサイクルイベント |
| OSイベント | iOS applicationDidBecomeActive: | アプリがアクティブ状態に復帰 | iOSアプリケーションデリゲート |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非モバイルプラットフォーム | Android/iOS以外では発火しない |
| SceneTree未初期化 | ルートノードが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[アプリがフォアグラウンドに復帰] --> B{プラットフォーム}
    B -->|Android| C[GodotLib.onResume]
    B -->|iOS| D[AppDelegateService applicationDidBecomeActive]
    C --> E[MainLoop::notification発火]
    D --> E
    E --> F[SceneTree::_notification]
    F --> G{ルートノード存在?}
    G -->|Yes| H[get_root->propagate_notification]
    H --> I[全ノードへ通知伝播]
    I --> J[復帰処理実行]
    J --> K[終了]
    G -->|No| K
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない内部通知）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ルートノード未存在 | SceneTreeが初期化されていない場合 | 通知をスキップ |
| リソース復帰失敗 | GPU/オーディオリソースの復帰失敗 | 再初期化を試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（アプリ復帰に応じて随時発火）

## セキュリティ考慮事項

- 復帰時に認証状態を再確認すべき
- バックグラウンド中にセッションがタイムアウトしている可能性を考慮

## 備考

- AndroidおよびiOSプラットフォームで実装されている
- NOTIFICATION_APPLICATION_PAUSEDとペアで使用される
- GDExtensionを通じても通知が発火される（core/extension/godot_instance.cpp）
- デスクトッププラットフォームでは代わりにNOTIFICATION_APPLICATION_FOCUS_INを使用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知の定数値とその定義場所を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main_loop.h | `core/os/main_loop.h` | NOTIFICATION_APPLICATION_RESUMED = 2014 の定義（55行目） |
| 1-2 | node.h | `scene/main/node.h` | Nodeクラスでの再定義（494行目） |

**読解のコツ**: MainLoopで定義された通知定数がNodeクラスで再定義されていることを確認する。

#### Step 2: プラットフォーム固有の実装を理解する

Android/iOS固有のライフサイクルイベント処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | java_godot_lib_jni.cpp | `platform/android/java_godot_lib_jni.cpp` | Android JNIからの呼び出し |
| 2-2 | os_apple_embedded.mm | `drivers/apple_embedded/os_apple_embedded.mm` | iOS固有のOS実装 |

**主要処理フロー**:
1. OSからのアプリ復帰イベント受信
2. MainLoopへの通知発火

#### Step 3: 通知伝播処理を理解する

SceneTreeでの通知処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scene_tree.cpp | `scene/main/scene_tree.cpp` | _notification()メソッドでのNOTIFICATION_APPLICATION_RESUMED処理（915行目） |

**主要処理フロー**:
1. **915行目**: `case NOTIFICATION_APPLICATION_RESUMED:` - 復帰ケースの判定
2. **920行目**: `get_root()->propagate_notification(p_notification)` - ルートから全ノードへ伝播

#### Step 4: GDExtension連携を理解する

GDExtensionからの通知発火を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | godot_instance.cpp | `core/extension/godot_instance.cpp` | GDExtension経由の通知発火 |

### プログラム呼び出し階層図

```
OS Application Lifecycle
    │
    ├─ [Android] GodotLib.onResume() (JNI)
    │      │
    │      └─ java_godot_lib_jni.cpp
    │             │
    │             └─ MainLoop::notification(NOTIFICATION_APPLICATION_RESUMED)
    │
    ├─ [iOS] AppDelegateService::applicationDidBecomeActive
    │      │
    │      └─ os_apple_embedded.mm
    │             │
    │             └─ MainLoop::notification(NOTIFICATION_APPLICATION_RESUMED)
    │
    └─ SceneTree::_notification()
           │
           └─ get_root()->propagate_notification()
                  │
                  └─ Node::_notification() [再帰的に伝播]
                         │
                         └─ アプリ復帰処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

OSアプリ復帰    プラットフォーム           MainLoop通知
イベント    ───▶ ハンドラ      ───▶      発火
                      │
                      ▼
                SceneTree
              _notification()
                      │
                      ▼
              全ノードへ伝播
                      │
                      ├───▶ オーディオ再開
                      │
                      ├───▶ ゲームロジック復帰
                      │
                      └───▶ ネットワーク再接続
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main_loop.h | `core/os/main_loop.h` | ソース | 通知定数の定義 |
| main_loop.cpp | `core/os/main_loop.cpp` | ソース | MainLoopの通知バインド |
| node.h | `scene/main/node.h` | ソース | Nodeクラスでの通知定数再定義 |
| scene_tree.cpp | `scene/main/scene_tree.cpp` | ソース | 通知の伝播処理 |
| java_godot_lib_jni.cpp | `platform/android/java_godot_lib_jni.cpp` | ソース | Android JNI実装 |
| os_apple_embedded.mm | `drivers/apple_embedded/os_apple_embedded.mm` | ソース | iOS固有OS実装 |
| godot_instance.cpp | `core/extension/godot_instance.cpp` | ソース | GDExtension連携 |
| MainLoop.xml | `doc/classes/MainLoop.xml` | ドキュメント | 通知の公式ドキュメント |
