# 通知設計書 6-Logger ERROR

## 概要

本ドキュメントは、GodotエンジンのカスタムLoggerクラスにおけるERROR_TYPE_ERROR通知の設計仕様を記述する。

### 本通知の処理概要

Logger ERRORは、CoreBind::Loggerクラスを継承したカスタムロガーが_log_errorコールバックで受信するエラータイプの通知である。開発者はGDScriptでLoggerを拡張し、エラー通知を独自の方法で処理（ファイル出力、ネットワーク送信、UI表示など）できる。

**業務上の目的・背景**：Godotの標準ログ出力では対応できない特殊なログ要件（リモートログサーバーへの送信、特定フォーマットでのファイル出力、カスタムUIへの表示など）に対応するため、開発者が独自のロガーを実装できる仕組みが必要である。Logger ERRORは、エンジン内で発生するすべてのエラー通知をカスタムロガーで受信するためのエラータイプである。

**通知の送信タイミング**：OS::add_logger()で登録されたカスタムLoggerに対して、エラーが発生するたびに_log_errorメソッドが呼び出される。ERROR_TYPE_ERRORは通常のエラー（ERR_PRINT、ERR_FAIL_*マクロなど）で発生する。

**通知の受信者**：OS::add_logger()で登録されたカスタムLoggerインスタンス。GDScriptでLoggerクラスを継承し、_log_errorメソッドをオーバーライドすることで受信できる。

**通知内容の概要**：関数名、ファイル名、行番号、エラーコード、エラー理由、エディタ通知フラグ、エラータイプ（ERROR_TYPE_ERROR=0）、スクリプトバックトレース配列が渡される。

**期待されるアクション**：カスタムロガーはエラー情報を独自の方法で処理する。例えば、外部サービスへの送信、データベースへの記録、カスタムUIへの表示、フィルタリング後の出力などが可能。

## 通知種別

カスタムロガー通知（Logger._log_errorコールバック）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コールバック呼び出し） |
| 優先度 | 高（エラーレベル） |
| リトライ | 無 |

### 送信先決定ロジック

- OS::add_logger()で登録されたすべてのLoggerに対して順次通知される
- CompositeLoggerを通じてLoggerBind::log_errorが呼び出される
- LoggerBindに登録されたすべてのCoreBind::Loggerの_log_errorが呼び出される

## 通知テンプレート

### コールバックパラメータ

| パラメータ | 型 | 説明 |
|-----------|-----|------|
| p_function | String | 呼び出し元関数名 |
| p_file | String | 呼び出し元ファイルパス |
| p_line | int | 呼び出し元行番号 |
| p_code | String | エラーコード |
| p_rationale | String | エラー理由/詳細説明 |
| p_editor_notify | bool | エディタ通知フラグ |
| p_type | int | エラータイプ（ERROR_TYPE_ERROR=0） |
| p_script_backtraces | TypedArray<ScriptBacktrace> | スクリプトバックトレース |

### 本文テンプレート

カスタムロガーの実装に依存

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| function | 呼び出し元関数名 | エラーマクロ | Yes |
| file | 呼び出し元ファイルパス | エラーマクロ | Yes |
| line | 呼び出し元行番号 | エラーマクロ | Yes |
| code | エラーコード | エラーマクロ | Yes |
| rationale | エラー理由 | エラーマクロ | No |
| editor_notify | エディタ通知フラグ | エラーマクロ | Yes |
| type | エラータイプ | ERROR_TYPE_ERROR | Yes |
| backtraces | スクリプトバックトレース | ScriptServer | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| エラーマクロ | ERR_PRINT, ERR_FAIL_* | Loggerが登録されている場合 | C++エラーマクロからの通知 |
| API呼び出し | push_error() | Loggerが登録されている場合 | GDScriptからのエラー出力 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| should_log(true) == false | エラー出力がグローバルで無効化されている場合 |
| Loggerが未登録 | OS::add_logger()で登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[エラー発生] --> B[_err_print_error呼び出し]
    B --> C[OS::print_error呼び出し]
    C --> D[CompositeLogger::log_error]
    D --> E[各Logger::log_error]
    E --> F{LoggerBindか?}
    F -->|Yes| G[LoggerBind::log_error]
    G --> H[各CoreBind::Logger]
    H --> I[_log_errorコールバック]
    I --> J{p_type==ERROR?}
    J -->|Yes| K[カスタム処理実行]
    J -->|No| L[他タイプとして処理]
    K --> M[終了]
    L --> M
    F -->|No| N[標準Logger処理]
    N --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし（データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コールバック未実装 | _log_errorがオーバーライドされていない | デフォルト動作（何もしない） |
| カスタムロガーでの例外 | _log_error内でエラー発生 | 再帰呼び出し防止機構により無視 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| レート制限 | なし |
| バッファリング | なし（即時コールバック） |

### 配信時間帯

制限なし（常時）

## セキュリティ考慮事項

- カスタムロガーはすべてのエラー情報にアクセス可能
- 機密情報を含むエラーメッセージの扱いに注意
- 外部サービスへの送信時は暗号化を検討
- フルパスが含まれる場合があるためシステム構成の露出に注意

## 備考

- ERROR_TYPE_ERRORは列挙値0である
- GDScriptでLoggerを継承して_log_errorをオーバーライドする
- OS.add_logger()でカスタムロガーを登録する
- 複数のロガーを登録可能（すべてに通知される）
- 標準出力ロガー（StdLogger）と共存可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Logger基底クラスとErrorType列挙型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | core_bind.h | `core/core_bind.h` | CoreBind::Logger クラス（123-142行目） |
| 1-2 | core_bind.h | `core/core_bind.h` | ErrorType列挙型（127-132行目）でERROR_TYPE_ERROR=0 |
| 1-3 | core_bind.h | `core/core_bind.h` | GDVIRTUAL8(_log_error, ...)定義（136行目） |

**読解のコツ**: CoreBind::LoggerはRefCountedを継承し、GDScriptから拡張可能。_log_errorはGDVIRTUAL8マクロで定義され、8引数のバーチャル関数として公開される。

#### Step 2: ロガー登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | core_bind.h | `core/core_bind.h` | LoggerBind内部クラス（149-157行目） |
| 2-2 | os.cpp | `core/os/os.cpp` | OS::add_logger実装（83-91行目） |

**主要処理フロー**:
1. **149行目**: LoggerBindはLoggerを継承
2. **150行目**: loggersはLocalVector<Ref<CoreBind::Logger>>
3. **83行目**: add_loggerでCompositeLoggerに追加

#### Step 3: エラー伝播を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logger.cpp | `core/io/logger.cpp` | CompositeLogger::log_error実装（255-262行目） |
| 3-2 | logger.h | `core/io/logger.h` | Logger::ErrorType定義（50-55行目） |

**主要処理フロー**:
- **255行目**: CompositeLogger::log_error開始
- **260-261行目**: すべての登録ロガーにlog_errorを呼び出し

#### Step 4: コールバック呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | core_bind.cpp | `core/core_bind.cpp` | Logger::log_error実装を検索 |

**主要処理フロー**:
- GDVIRTUAL_CALL(_log_error, ...)でGDScript側の_log_errorを呼び出し

### プログラム呼び出し階層図

```
ERR_PRINT(message) / push_error()
    │
    └─ _err_print_error(...)
           │
           └─ OS::get_singleton()->print_error(...)
                  │
                  └─ CompositeLogger::log_error(...)
                         │
                         ├─ StdLogger::log_error(...)  → 標準出力
                         │
                         └─ LoggerBind::log_error(...)
                                │
                                └─ 各CoreBind::Logger
                                       │
                                       └─ GDVIRTUAL_CALL(_log_error, ...)
                                              │
                                              └─ GDScript._log_error(
                                                    function, file, line,
                                                    code, rationale,
                                                    editor_notify,
                                                    ERROR_TYPE_ERROR,
                                                    backtraces
                                                 )
```

### データフロー図

```
[入力]                    [処理]                           [出力]

p_function    ───▶  _err_print_error()
p_file        ───▶        │
p_line        ───▶        │
p_code        ───▶  OS::print_error()
p_rationale   ───▶        │
p_editor_notify ─▶        │
p_type=ERROR  ───▶  CompositeLogger::log_error()
backtraces    ───▶        │
                          │
                    ┌─────┴─────┐
                    ▼           ▼
              StdLogger    LoggerBind
              (標準出力)         │
                                │
                    ┌───────────┼───────────┐
                    ▼           ▼           ▼
              Logger1      Logger2      Logger3
              (GDScript)   (GDScript)   (GDScript)
                    │           │           │
                    ▼           ▼           ▼
              _log_error   _log_error   _log_error
              カスタム処理  カスタム処理  カスタム処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| core_bind.h | `core/core_bind.h` | ソース | CoreBind::Logger定義、ErrorType定義 |
| core_bind.cpp | `core/core_bind.cpp` | ソース | Logger::log_error実装 |
| logger.h | `core/io/logger.h` | ソース | Logger基底クラス、ErrorType（core側） |
| logger.cpp | `core/io/logger.cpp` | ソース | CompositeLogger実装 |
| os.h | `core/os/os.h` | ソース | OS::add_logger宣言 |
| os.cpp | `core/os/os.cpp` | ソース | OS::add_logger実装 |
