# 通知設計書 60-NOTIFICATION_APPLICATION_FOCUS_IN

## 概要

本ドキュメントは、Godotエンジンにおけるアプリケーションがフォーカスを取得した際に発火するNOTIFICATION_APPLICATION_FOCUS_IN通知の設計仕様を定義する。

### 本通知の処理概要

NOTIFICATION_APPLICATION_FOCUS_INは、アプリケーションがフォーカスを取得した際に発火するシステム通知である。デスクトッププラットフォームでは他のアプリケーションからGodotアプリケーションに切り替えた時、モバイルプラットフォームではアプリがアクティブになった時に発火する。

**業務上の目的・背景**：ユーザーが他のアプリケーションやデスクトップからGodotアプリケーションに戻った際に、適切な処理を実行する必要がある。例えば、一時停止していたゲームの再開確認ダイアログの表示、入力状態のリセット、サーバーとの再同期などが挙げられる。デスクトッププラットフォームではウィンドウフォーカスとは異なり、アプリケーション全体のフォーカス状態を示す。

**通知の送信タイミング**：アプリケーションがOSからフォーカスを取得した時点で発火する。デスクトップではウィンドウがアクティブになった時、モバイルではアプリがフォアグラウンドになった時に相当する。

**通知の受信者**：SceneTreeのルートノードから全ての子ノードに対して`propagate_notification`を通じて伝播される。

**通知内容の概要**：通知値2016を持つ整数通知として送信される。追加のパラメータは含まれない。

**期待されるアクション**：受信者はアプリケーションフォーカス取得に伴う処理を実行することが期待される。具体的には、入力状態のリセット、UIの更新、一時停止状態からの復帰確認などが挙げられる。

## 通知種別

エンジン内部通知（Object._notification経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

SceneTree::_notification()で受信後、get_root()->propagate_notification()を通じてルートノードから全ての子ノードに伝播される。

## 通知テンプレート

### 通知定数定義

| 項目 | 内容 |
|-----|------|
| 定数名 | NOTIFICATION_APPLICATION_FOCUS_IN |
| 値 | 2016 |
| 定義場所 | core/os/main_loop.h（Nodeで再定義） |

### 受信処理例

```gdscript
func _notification(what):
    if what == NOTIFICATION_APPLICATION_FOCUS_IN:
        # アプリがフォーカスを取得した時の処理
        _on_focus_gained()

func _on_focus_gained():
    # 入力状態をリセット
    Input.action_release("ui_accept")
    # UIを更新
    _refresh_ui()
    # 必要に応じて一時停止確認
    if was_playing_before_focus_lost:
        _show_resume_dialog()
    print("Application gained focus")
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 追加パラメータなし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムイベント | アプリケーションアクティブ化 | 他アプリからの切り替え | デスクトップ/モバイル共通 |
| ウィンドウイベント | ウィンドウフォーカス取得 | ウィンドウがアクティブに | デスクトッププラットフォーム |
| OSイベント | フォアグラウンド復帰 | アプリがフォアグラウンドに | モバイルプラットフォーム |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| SceneTree未初期化 | ルートノードが存在しない場合 |
| 既にフォーカス状態 | 連続した同一通知の抑止 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[アプリがフォーカスを取得] --> B{プラットフォーム}
    B -->|Desktop| C[DisplayServer フォーカスイベント]
    B -->|Android| D[GodotLib.onFocus]
    B -->|iOS| E[AppDelegateService]
    C --> F[MainLoop::notification発火]
    D --> F
    E --> F
    F --> G[SceneTree::_notification]
    G --> H{ルートノード存在?}
    H -->|Yes| I[get_root->propagate_notification]
    I --> J[全ノードへ通知伝播]
    J --> K[フォーカス取得処理実行]
    K --> L[終了]
    H -->|No| L
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない内部通知）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ルートノード未存在 | SceneTreeが初期化されていない場合 | 通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（フォーカス取得に応じて随時発火）

## セキュリティ考慮事項

特別な考慮事項なし。内部通知であり、外部からのアクセスは不可。

## 備考

- デスクトップおよびモバイルプラットフォームで実装されている
- NOTIFICATION_APPLICATION_FOCUS_OUTとペアで使用される
- NOTIFICATION_WM_WINDOW_FOCUS_INとは異なる（アプリケーション全体 vs 個別ウィンドウ）
- GDExtensionを通じても通知が発火される（core/extension/godot_instance.cpp）
- エディタでは特定のシナリオで使用される（embedded_process等）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知の定数値とその定義場所を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main_loop.h | `core/os/main_loop.h` | NOTIFICATION_APPLICATION_FOCUS_IN = 2016 の定義（57行目） |
| 1-2 | node.h | `scene/main/node.h` | Nodeクラスでの再定義（496行目） |

**読解のコツ**: MainLoopで定義された通知定数がNodeクラスで再定義されていることを確認する。

#### Step 2: プラットフォーム固有の実装を理解する

各プラットフォームのフォーカスイベント処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | display_server_windows.cpp | `platform/windows/display_server_windows.cpp` | Windows フォーカスイベント |
| 2-2 | display_server_x11.cpp | `platform/linuxbsd/x11/display_server_x11.cpp` | X11 フォーカスイベント |
| 2-3 | display_server_wayland.cpp | `platform/linuxbsd/wayland/display_server_wayland.cpp` | Wayland フォーカスイベント |
| 2-4 | godot_application_delegate.mm | `platform/macos/godot_application_delegate.mm` | macOS フォーカスイベント |
| 2-5 | os_android.cpp | `platform/android/os_android.cpp` | Android フォーカスイベント |

**主要処理フロー**:
1. OSからのフォーカスイベント受信
2. MainLoopへの通知発火

#### Step 3: 通知伝播処理を理解する

SceneTreeでの通知処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scene_tree.cpp | `scene/main/scene_tree.cpp` | _notification()メソッドでのNOTIFICATION_APPLICATION_FOCUS_IN処理（917行目） |

**主要処理フロー**:
1. **917行目**: `case NOTIFICATION_APPLICATION_FOCUS_IN:` - フォーカス取得ケースの判定
2. **920行目**: `get_root()->propagate_notification(p_notification)` - ルートから全ノードへ伝播

#### Step 4: エディタでの使用例を理解する

エディタでのこの通知の使用例を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | embedded_process.cpp | `editor/run/embedded_process.cpp` | エディタ埋め込みプロセスでの使用 |
| 4-2 | embedded_process_macos.mm | `platform/macos/editor/embedded_process_macos.mm` | macOS埋め込みプロセス |

### プログラム呼び出し階層図

```
OS Focus Event
    │
    ├─ [Windows] DisplayServerWindows::_handle_focus()
    │
    ├─ [X11] DisplayServerX11::_handle_focus_event()
    │
    ├─ [Wayland] DisplayServerWayland::_handle_focus()
    │
    ├─ [macOS] GodotApplicationDelegate::applicationDidBecomeActive
    │
    ├─ [Android] OS_Android::set_main_loop() / on_focus
    │
    └─ MainLoop::notification(NOTIFICATION_APPLICATION_FOCUS_IN)
           │
           └─ SceneTree::_notification()
                  │
                  └─ get_root()->propagate_notification()
                         │
                         └─ Node::_notification() [再帰的に伝播]
                                │
                                ├─ 入力状態リセット
                                │
                                ├─ UI更新
                                │
                                └─ 復帰処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

OSフォーカス    プラットフォーム           MainLoop通知
イベント    ───▶ ハンドラ      ───▶      発火
                      │
                      ▼
                SceneTree
              _notification()
                      │
                      ▼
              全ノードへ伝播
                      │
                      ├───▶ 入力状態リセット
                      │
                      ├───▶ UI更新
                      │
                      └───▶ 復帰処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main_loop.h | `core/os/main_loop.h` | ソース | 通知定数の定義 |
| main_loop.cpp | `core/os/main_loop.cpp` | ソース | MainLoopの通知バインド |
| node.h | `scene/main/node.h` | ソース | Nodeクラスでの通知定数再定義 |
| scene_tree.cpp | `scene/main/scene_tree.cpp` | ソース | 通知の伝播処理 |
| display_server_windows.cpp | `platform/windows/display_server_windows.cpp` | ソース | Windows フォーカス処理 |
| display_server_x11.cpp | `platform/linuxbsd/x11/display_server_x11.cpp` | ソース | X11 フォーカス処理 |
| display_server_wayland.cpp | `platform/linuxbsd/wayland/display_server_wayland.cpp` | ソース | Wayland フォーカス処理 |
| godot_application_delegate.mm | `platform/macos/godot_application_delegate.mm` | ソース | macOS フォーカス処理 |
| os_android.cpp | `platform/android/os_android.cpp` | ソース | Android フォーカス処理 |
| godot_instance.cpp | `core/extension/godot_instance.cpp` | ソース | GDExtension連携 |
| embedded_process.cpp | `editor/run/embedded_process.cpp` | ソース | エディタ埋め込みプロセス |
| MainLoop.xml | `doc/classes/MainLoop.xml` | ドキュメント | 通知の公式ドキュメント |
