# 通知設計書 61-NOTIFICATION_APPLICATION_FOCUS_OUT

## 概要

本ドキュメントは、Godotエンジンにおける`NOTIFICATION_APPLICATION_FOCUS_OUT`通知の設計仕様を定義する。この通知はアプリケーションがフォーカスを喪失した際にMainLoopおよびNodeに対して送信される内部通知である。

### 本通知の処理概要

`NOTIFICATION_APPLICATION_FOCUS_OUT`通知は、アプリケーションウィンドウが他のアプリケーションにフォーカスを奪われた際に、ゲームやエディタ内のすべてのノードに対して処理の一時停止やリソースの解放を促すために使用される。

**業務上の目的・背景**：ユーザーがアプリケーションから離れた（別のウィンドウに切り替えた）際に、ゲームロジックの一時停止、オーディオの停止、リソース使用量の削減などを行うために必要である。特にモバイルプラットフォームやゲーム開発において、バックグラウンド時の動作制御は重要な機能である。

**通知の送信タイミング**：OSレベルでアプリケーションウィンドウがフォーカスを失った瞬間に送信される。具体的には、DisplayServerがウィンドウフォーカス喪失イベントを検知した際に発火する。Windowsでは`WM_KILLFOCUS`、macOSでは`applicationDidResignActive`、Linuxでは`FocusOut`イベントに対応する。

**通知の受信者**：MainLoopを継承するクラス（SceneTreeなど）およびシーンツリー内のすべてのNode派生クラス。propagate_notificationにより子ノードにも伝播される。

**通知内容の概要**：通知値は`2017`（MainLoop::NOTIFICATION_APPLICATION_FOCUS_OUT）。追加のパラメータは含まれない。

**期待されるアクション**：受信者は必要に応じてゲームのポーズ処理、バックグラウンドオーディオの停止、アニメーションの停止、入力処理の無効化などを実装する。

## 通知種別

アプリ内通知（エンジン内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

MainLoopインスタンスおよびSceneTree経由でシーンツリー内の全ノードに対してpropagate_notificationで伝播される。

## 通知テンプレート

### エンジン内部通知の場合

| 項目 | 内容 |
|-----|------|
| 通知定数名 | NOTIFICATION_APPLICATION_FOCUS_OUT |
| 通知値 | 2017 |
| 定義クラス | MainLoop / Node |

### 通知ペイロード

通知に追加データは含まれない。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_notification | 通知ID（2017） | エンジン内部 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| OSイベント | ウィンドウフォーカス喪失 | アプリケーションが前面から離れた時 | DisplayServerがOS固有のフォーカス喪失イベントを検知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| アプリケーション未初期化 | MainLoopが設定されていない場合は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OSがフォーカス喪失を検知] --> B[DisplayServer::process_events]
    B --> C[OS::get_singleton->get_main_loop]
    C --> D{MainLoopが存在?}
    D -->|Yes| E[MainLoop::notification FOCUS_OUT]
    D -->|No| F[処理終了]
    E --> G[SceneTree::_notification]
    G --> H[ノードへpropagate_notification]
    H --> I[各ノードの_notificationが呼び出される]
    I --> J[処理終了]
    F --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

### 更新テーブル一覧

本通知はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| MainLoop未設定 | アプリケーション初期化前 | 通知送信をスキップ |
| ノード破棄済み | 通知処理中にノードが削除 | 処理を安全にスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（OSイベント依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

常時（OSイベント発生時）

## セキュリティ考慮事項

- 本通知はエンジン内部の通知であり、外部からの直接送信は不可能
- ユーザースクリプトは`_notification`メソッドで受信可能だが、通知の偽装は不可能

## 備考

- 対となる通知として`NOTIFICATION_APPLICATION_FOCUS_IN`（2016）がある
- モバイルプラットフォームでは`NOTIFICATION_APPLICATION_PAUSED`と併用されることが多い
- エディタ実行中もこの通知は発生する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知定数の定義場所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main_loop.h | `core/os/main_loop.h` | 48-60行目でNOTIFICATION_APPLICATION_FOCUS_OUTが2017として定義されていることを確認 |
| 1-2 | node.h | `scene/main/node.h` | 496-498行目でNodeクラスにMainLoop::NOTIFICATION_APPLICATION_FOCUS_OUTが継承定義されていることを確認 |

**読解のコツ**: MainLoopで定義された通知定数がNodeにも継承されている点に注目する。

#### Step 2: エントリーポイントを理解する

プラットフォーム固有のフォーカス喪失検知処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | display_server_windows.cpp | `platform/windows/display_server_windows.cpp` | WindowsプラットフォームでのWM_KILLFOCUS処理 |
| 2-2 | godot_application_delegate.mm | `platform/macos/godot_application_delegate.mm` | macOSでのapplicationDidResignActive処理 |

**主要処理フロー**:
1. OSがフォーカス喪失イベントを発火
2. DisplayServerがイベントを処理
3. `OS::get_singleton()->get_main_loop()->notification()`を呼び出し

#### Step 3: 通知伝播処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main_loop.cpp | `core/os/main_loop.cpp` | 33-43行目で通知定数がバインドされている |
| 3-2 | scene_tree.cpp | `scene/main/scene_tree.cpp` | SceneTreeでの通知処理とノードへの伝播 |
| 3-3 | node.cpp | `scene/main/node.cpp` | 60-315行目の_notification処理を確認 |

**主要処理フロー**:
- **42行目**: `BIND_CONSTANT(NOTIFICATION_APPLICATION_FOCUS_OUT);`で定数がスクリプトに公開

### プログラム呼び出し階層図

```
OS/DisplayServer (platform specific)
    │
    ├─ DisplayServer::process_events()
    │      └─ MainLoop::notification(NOTIFICATION_APPLICATION_FOCUS_OUT)
    │
    └─ SceneTree::_notification()
           └─ Node::propagate_notification()
                  └─ 各ノードの_notification()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

OS フォーカス      ───▶ DisplayServer ───▶ MainLoop::notification()
喪失イベント                                        │
                                                    ▼
                                        SceneTree::_notification()
                                                    │
                                                    ▼
                                        全ノードへ通知伝播
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main_loop.h | `core/os/main_loop.h` | ソース | 通知定数の定義 |
| main_loop.cpp | `core/os/main_loop.cpp` | ソース | 通知定数のバインド |
| node.h | `scene/main/node.h` | ソース | Node側の通知定数定義 |
| node.cpp | `scene/main/node.cpp` | ソース | ノードの通知処理 |
| scene_tree.cpp | `scene/main/scene_tree.cpp` | ソース | シーンツリーでの通知処理 |
| display_server_windows.cpp | `platform/windows/display_server_windows.cpp` | ソース | Windows固有の実装 |
| display_server_x11.cpp | `platform/linuxbsd/x11/display_server_x11.cpp` | ソース | Linux X11固有の実装 |
| godot_application_delegate.mm | `platform/macos/godot_application_delegate.mm` | ソース | macOS固有の実装 |
