# 通知設計書 62-NOTIFICATION_TEXT_SERVER_CHANGED

## 概要

本ドキュメントは、Godotエンジンにおける`NOTIFICATION_TEXT_SERVER_CHANGED`通知の設計仕様を定義する。この通知はテキストサーバー（テキストレンダリングエンジン）が変更された際にMainLoopおよびNodeに対して送信される内部通知である。

### 本通知の処理概要

`NOTIFICATION_TEXT_SERVER_CHANGED`通知は、アプリケーションで使用されるテキストサーバー（TextServer）が動的に変更された際に、すべてのノードに対してテキスト描画やフォント処理のリフレッシュを促すために使用される。

**業務上の目的・背景**：Godotエンジンは複数のテキストレンダリングバックエンド（TextServerAdvanced、TextServerFallbackなど）をサポートしており、実行時にこれを切り替える機能がある。テキストサーバーが変更された場合、文字の描画方法、フォントのレンダリング、双方向テキスト処理などが変化するため、すべてのUIコンポーネントに再描画を促す必要がある。

**通知の送信タイミング**：`TextServerManager::set_primary_interface()`メソッドが呼び出され、プライマリテキストサーバーが別のインスタンスに変更された時点で送信される。

**通知の受信者**：MainLoopを継承するクラス（SceneTreeなど）およびシーンツリー内のすべてのNode派生クラス。特にLabel、RichTextLabel、LineEditなどのテキスト描画を行うコントロールノードが主な対象。

**通知内容の概要**：通知値は`2018`（MainLoop::NOTIFICATION_TEXT_SERVER_CHANGED）。追加のパラメータは含まれない。

**期待されるアクション**：受信者は必要に応じてテキストキャッシュのクリア、フォントデータの再読み込み、テキストレイアウトの再計算、キャンバスの再描画などを実装する。

## 通知種別

アプリ内通知（エンジン内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

TextServerManagerがMainLoopに通知を送信し、SceneTree経由でシーンツリー内の全ノードに対してpropagate_notificationで伝播される。

## 通知テンプレート

### エンジン内部通知の場合

| 項目 | 内容 |
|-----|------|
| 通知定数名 | NOTIFICATION_TEXT_SERVER_CHANGED |
| 通知値 | 2018 |
| 定義クラス | MainLoop / Node |

### 通知ペイロード

通知に追加データは含まれない。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_notification | 通知ID（2018） | エンジン内部 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | TextServerManager::set_primary_interface() | 新しいTextServerが設定された時 | プライマリテキストサーバーの変更 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 同一インターフェース設定 | 既存と同じTextServerが再設定された場合（暗黙的スキップ） |
| MainLoop未設定 | OS::get_singleton()->get_main_loop()がnullの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[TextServerManager::set_primary_interface呼び出し] --> B{インターフェースがnull?}
    B -->|Yes| C[プライマリインターフェースをクリア]
    B -->|No| D[プライマリインターフェースを設定]
    D --> E{MainLoopが存在?}
    E -->|Yes| F[MainLoop::notification TEXT_SERVER_CHANGED]
    E -->|No| G[処理終了]
    F --> H[SceneTree::_notification]
    H --> I[ノードへpropagate_notification]
    I --> J[各ノードがテキスト再描画]
    J --> K[処理終了]
    C --> G
    G --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

### 更新テーブル一覧

本通知はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| MainLoop未設定 | アプリケーション初期化前 | 通知送信をスキップ |
| 無効なTextServer | TextServerインターフェースが破損 | ERR_FAIL_CONDマクロで処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（API呼び出し依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

常時（API呼び出し時）

## セキュリティ考慮事項

- 本通知はエンジン内部の通知であり、外部からの直接送信は不可能
- TextServerの変更はエンジンレベルのAPIであり、通常のGDScriptからは直接呼び出し不可

## 備考

- TextServerの変更は通常、アプリケーション起動時または設定変更時にのみ発生する稀な操作
- 高度なテキスト機能（RTL、複雑なスクリプト）を必要とするアプリケーションで使用される
- TextServerAdvanced（ICU/HarfBuzz使用）とTextServerFallback（基本機能のみ）の切り替えが主なユースケース

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知定数の定義場所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main_loop.h | `core/os/main_loop.h` | 59行目でNOTIFICATION_TEXT_SERVER_CHANGEDが2018として定義されていることを確認 |
| 1-2 | node.h | `scene/main/node.h` | 498行目でNodeクラスにMainLoop::NOTIFICATION_TEXT_SERVER_CHANGEDが継承定義されていることを確認 |

**読解のコツ**: MainLoopで定義された通知定数がNodeにも継承されている点に注目する。

#### Step 2: エントリーポイントを理解する

通知を発火するTextServerManagerの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | text_server.cpp | `servers/text/text_server.cpp` | 130-142行目のset_primary_interface()メソッドで通知が送信される処理を確認 |

**主要処理フロー**:
1. **130行目**: `set_primary_interface()`メソッド開始
2. **136行目**: `primary_interface = p_primary_interface;`でプライマリサーバー設定
3. **138-139行目**: MainLoopが存在すれば`notification(MainLoop::NOTIFICATION_TEXT_SERVER_CHANGED)`を呼び出し

#### Step 3: 通知定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main_loop.cpp | `core/os/main_loop.cpp` | 43行目で`BIND_CONSTANT(NOTIFICATION_TEXT_SERVER_CHANGED);`が定義されている |
| 3-2 | node.cpp | `scene/main/node.cpp` | ノードでの通知処理（_notification関数） |

**主要処理フロー**:
- **43行目**: スクリプトへの定数公開

### プログラム呼び出し階層図

```
TextServerManager
    │
    └─ set_primary_interface(Ref<TextServer>)
           │
           ├─ primary_interface = p_primary_interface
           │
           └─ OS::get_singleton()->get_main_loop()->notification()
                  │
                  └─ MainLoop::NOTIFICATION_TEXT_SERVER_CHANGED
                         │
                         └─ SceneTree → 全ノードへ伝播
```

### データフロー図

```
[入力]                      [処理]                              [出力]

TextServer         ───▶ TextServerManager              ───▶ MainLoop::notification()
インターフェース変更        set_primary_interface()                   │
                                                                      ▼
                                                           SceneTree::_notification()
                                                                      │
                                                                      ▼
                                                           テキスト描画ノード再描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main_loop.h | `core/os/main_loop.h` | ソース | 通知定数の定義 |
| main_loop.cpp | `core/os/main_loop.cpp` | ソース | 通知定数のバインド |
| node.h | `scene/main/node.h` | ソース | Node側の通知定数定義 |
| node.cpp | `scene/main/node.cpp` | ソース | ノードの通知処理 |
| text_server.cpp | `servers/text/text_server.cpp` | ソース | TextServerManager実装・通知発火 |
| text_server.h | `servers/text/text_server.h` | ソース | TextServerクラス定義 |
| label.cpp | `scene/gui/label.cpp` | ソース | Label通知処理例 |
| rich_text_label.cpp | `scene/gui/rich_text_label.cpp` | ソース | RichTextLabel通知処理例 |
