# 通知設計書 63-peer_connected

## 概要

本ドキュメントは、Godotエンジンにおける`peer_connected`シグナルの設計仕様を定義する。このシグナルはマルチプレイヤー通信においてリモートピアが接続した際にMultiplayerPeerから発火される通知機能である。

### 本通知の処理概要

`peer_connected`シグナルは、ネットワークマルチプレイヤー環境において、新しいピア（プレイヤーまたはクライアント）がネットワークセッションに参加した際に発火される。このシグナルにより、既存のピアは新規参加者を認識し、適切な初期化処理を行うことができる。

**業務上の目的・背景**：マルチプレイヤーゲームやネットワークアプリケーションにおいて、新しい参加者の接続を検知することは基本的な要件である。プレイヤーリストの更新、ゲーム状態の同期、ウェルカムメッセージの送信などの処理を実装するために必要不可欠なシグナルである。

**通知の送信タイミング**：リモートピアがネットワークセッションに正常に接続を完了した時点で発火される。ENet、WebSocket、WebRTCなど使用するネットワークプロトコルによって具体的なタイミングは異なるが、接続ハンドシェイク完了後に発火される。

**通知の受信者**：MultiplayerPeerインスタンスに接続されたシグナルハンドラ。通常はゲームロジックを管理するスクリプトがこのシグナルを監視する。

**通知内容の概要**：接続したピアの一意のID（int型）がパラメータとして渡される。

**期待されるアクション**：受信者は新規ピアへの初期データ送信、プレイヤーリストの更新、UIの更新、ゲーム状態の同期などを実装する。

## 通知種別

シグナル通知（Godotシグナルシステム）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（シグナル） |
| 優先度 | 高 |
| リトライ | なし（ネットワーク層で処理） |

### 送信先決定ロジック

MultiplayerPeerにconnectメソッドで登録されたすべてのシグナルハンドラに対して発火される。

## 通知テンプレート

### シグナル定義

| 項目 | 内容 |
|-----|------|
| シグナル名 | peer_connected |
| 定義クラス | MultiplayerPeer |
| パラメータ数 | 1 |

### シグナルパラメータ

| パラメータ名 | 型 | 説明 |
|------------|-----|------|
| id | int | 接続したピアの一意ID |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| id | ピアID（正の整数） | MultiplayerPeer内部生成 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ネットワークイベント | ピア接続完了 | ハンドシェイク成功 | リモートピアとの接続が確立された時 |
| サーバー参加 | クライアントがサーバーに接続 | 接続受け入れ | 新規クライアントがサーバーに参加 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| refuse_new_connections有効 | set_refuse_new_connections(true)の場合、新規接続は拒否される |
| 接続上限到達 | プロトコル固有の接続上限に達している場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リモートピアからの接続要求] --> B{接続受け入れ可能?}
    B -->|Yes| C[接続ハンドシェイク]
    B -->|No| D[接続拒否]
    C --> E{ハンドシェイク成功?}
    E -->|Yes| F[ピアIDを生成/割り当て]
    E -->|No| G[接続失敗]
    F --> H[peer_connectedシグナル発火]
    H --> I[接続済みハンドラが呼び出される]
    I --> J[処理終了]
    D --> J
    G --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

本シグナルはデータベースを使用しない。

### 更新テーブル一覧

本シグナルはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 接続拒否 | refuse_new_connections有効 | シグナルは発火されない |
| ハンドシェイク失敗 | ネットワークエラー | 接続試行を再実行 |
| ピアID重複 | 極めて稀なケース | 新しいIDを再生成 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | ネットワーク層依存 |
| リトライ間隔 | プロトコル依存 |
| リトライ対象エラー | 接続タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | プロトコル依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

常時（ネットワークイベント発生時）

## セキュリティ考慮事項

- ピアIDは予測困難な値として生成される（generate_unique_id使用）
- 接続要求の検証はプロトコル層で行われる
- 悪意のある接続を防ぐためrefuse_new_connectionsを適切に使用する

## 備考

- 対となるシグナルとして`peer_disconnected`がある
- サーバーのピアIDは常に1である
- ENet、WebSocket、WebRTCの各実装で同一のシグナルインターフェースを提供

---

## コードリーディングガイド

本シグナルを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、シグナルの定義場所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | multiplayer_peer.cpp | `scene/main/multiplayer_peer.cpp` | 124行目でADD_SIGNALによりpeer_connectedシグナルが定義されている |
| 1-2 | multiplayer_peer.h | `scene/main/multiplayer_peer.h` | MultiplayerPeerクラスの構造を確認 |

**読解のコツ**: ADD_SIGNALマクロでシグナル名とパラメータが定義されている点に注目する。

#### Step 2: エントリーポイントを理解する

シグナルを発火する各プロトコル実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | enet_multiplayer_peer.cpp | `modules/enet/enet_multiplayer_peer.cpp` | ENet実装でのpeer_connected発火処理 |
| 2-2 | websocket_multiplayer_peer.cpp | `modules/websocket/websocket_multiplayer_peer.cpp` | WebSocket実装でのpeer_connected発火処理 |
| 2-3 | webrtc_multiplayer_peer.cpp | `modules/webrtc/webrtc_multiplayer_peer.cpp` | WebRTC実装でのpeer_connected発火処理 |

**主要処理フロー**:
1. ネットワーク層で接続イベント検知
2. ピアIDの割り当て
3. `emit_signal(SNAME("peer_connected"), peer_id)`でシグナル発火

#### Step 3: シグナル定義詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | multiplayer_peer.cpp | `scene/main/multiplayer_peer.cpp` | 85-126行目の_bind_methods()でシグナルとメソッドが定義されている |

**主要処理フロー**:
- **124行目**: `ADD_SIGNAL(MethodInfo("peer_connected", PropertyInfo(Variant::INT, "id")));`

### プログラム呼び出し階層図

```
ネットワークプロトコル層（ENet/WebSocket/WebRTC）
    │
    ├─ poll() / _process_poll()
    │      └─ 接続イベント検知
    │
    └─ emit_signal("peer_connected", peer_id)
           │
           └─ 接続されたシグナルハンドラ
                  └─ ゲームロジック処理
```

### データフロー図

```
[入力]                    [処理]                              [出力]

リモートピア       ───▶ MultiplayerPeer実装         ───▶ peer_connectedシグナル
接続要求                  (ENet/WS/WebRTC)                      │
                                │                               ▼
                                ▼                    シグナルハンドラ呼び出し
                         ピアID生成                           │
                                                              ▼
                                                    ゲームロジック処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| multiplayer_peer.cpp | `scene/main/multiplayer_peer.cpp` | ソース | シグナル定義・基底クラス実装 |
| multiplayer_peer.h | `scene/main/multiplayer_peer.h` | ソース | MultiplayerPeerクラス定義 |
| multiplayer_api.cpp | `scene/main/multiplayer_api.cpp` | ソース | マルチプレイヤーAPI実装 |
| enet_multiplayer_peer.cpp | `modules/enet/enet_multiplayer_peer.cpp` | ソース | ENetプロトコル実装 |
| websocket_multiplayer_peer.cpp | `modules/websocket/websocket_multiplayer_peer.cpp` | ソース | WebSocketプロトコル実装 |
| webrtc_multiplayer_peer.cpp | `modules/webrtc/webrtc_multiplayer_peer.cpp` | ソース | WebRTCプロトコル実装 |
| scene_multiplayer.cpp | `modules/multiplayer/scene_multiplayer.cpp` | ソース | シーンマルチプレイヤー実装 |
