# 通知設計書 64-peer_disconnected

## 概要

本ドキュメントは、Godotエンジンにおける`peer_disconnected`シグナルの設計仕様を定義する。このシグナルはマルチプレイヤー通信においてリモートピアが切断した際にMultiplayerPeerから発火される通知機能である。

### 本通知の処理概要

`peer_disconnected`シグナルは、ネットワークマルチプレイヤー環境において、既存のピア（プレイヤーまたはクライアント）がネットワークセッションから離脱した際に発火される。このシグナルにより、残りのピアは離脱者を認識し、適切なクリーンアップ処理を行うことができる。

**業務上の目的・背景**：マルチプレイヤーゲームやネットワークアプリケーションにおいて、参加者の切断を検知することは重要な要件である。プレイヤーリストからの削除、ゲーム状態の更新、リソースの解放、他プレイヤーへの通知などの処理を実装するために必要不可欠なシグナルである。

**通知の送信タイミング**：リモートピアがネットワークセッションから切断された時点で発火される。正常な切断（明示的なdisconnect）とタイムアウトによる切断の両方で発火される。

**通知の受信者**：MultiplayerPeerインスタンスに接続されたシグナルハンドラ。通常はゲームロジックを管理するスクリプトがこのシグナルを監視する。

**通知内容の概要**：切断したピアの一意のID（int型）がパラメータとして渡される。

**期待されるアクション**：受信者は切断ピアに関連するリソースの解放、プレイヤーリストの更新、UIの更新、ゲーム状態の調整などを実装する。

## 通知種別

シグナル通知（Godotシグナルシステム）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（シグナル） |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

MultiplayerPeerにconnectメソッドで登録されたすべてのシグナルハンドラに対して発火される。

## 通知テンプレート

### シグナル定義

| 項目 | 内容 |
|-----|------|
| シグナル名 | peer_disconnected |
| 定義クラス | MultiplayerPeer |
| パラメータ数 | 1 |

### シグナルパラメータ

| パラメータ名 | 型 | 説明 |
|------------|-----|------|
| id | int | 切断したピアの一意ID |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| id | ピアID（正の整数） | MultiplayerPeer内部管理 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ネットワークイベント | ピア切断検知 | 接続断 | リモートピアとの接続が切断された時 |
| 明示的切断 | disconnect_peer呼び出し | API呼び出し | プログラムからの明示的な切断要求 |
| タイムアウト | 応答なし | 一定時間応答がない場合 | ネットワークタイムアウト |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 接続未確立 | そもそも接続が確立されていないピア |
| 既に切断処理済み | 同一ピアに対して既にシグナルが発火済み |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[切断イベント検知] --> B{切断種別}
    B -->|正常切断| C[disconnect_peer処理]
    B -->|タイムアウト| D[タイムアウト処理]
    B -->|ネットワークエラー| E[エラー処理]
    C --> F[peer_disconnectedシグナル発火]
    D --> F
    E --> F
    F --> G[接続済みハンドラが呼び出される]
    G --> H[ピア情報のクリーンアップ]
    H --> I[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本シグナルはデータベースを使用しない。

### 更新テーブル一覧

本シグナルはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効なピアID | 存在しないピアIDを指定 | エラーをログに記録し処理継続 |
| 多重切断 | 既に切断済みのピアへの操作 | 処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（切断は一回のみ） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

常時（ネットワークイベント発生時）

## セキュリティ考慮事項

- 切断シグナルは実際の切断イベントに基づいて発火され、偽装は困難
- 悪意のある切断攻撃に対する対策はアプリケーション層で実装が必要

## 備考

- 対となるシグナルとして`peer_connected`がある
- disconnect_peerメソッドでforceパラメータをtrueにすると即時切断
- サーバーが切断した場合、すべてのクライアントでこのシグナルが発火される

---

## コードリーディングガイド

本シグナルを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、シグナルの定義場所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | multiplayer_peer.cpp | `scene/main/multiplayer_peer.cpp` | 125行目でADD_SIGNALによりpeer_disconnectedシグナルが定義されている |
| 1-2 | multiplayer_peer.h | `scene/main/multiplayer_peer.h` | MultiplayerPeerクラスの構造を確認 |

**読解のコツ**: ADD_SIGNALマクロでシグナル名とパラメータが定義されている点に注目する。

#### Step 2: エントリーポイントを理解する

シグナルを発火する各プロトコル実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | enet_multiplayer_peer.cpp | `modules/enet/enet_multiplayer_peer.cpp` | ENet実装でのpeer_disconnected発火処理 |
| 2-2 | websocket_multiplayer_peer.cpp | `modules/websocket/websocket_multiplayer_peer.cpp` | WebSocket実装でのpeer_disconnected発火処理 |
| 2-3 | webrtc_multiplayer_peer.cpp | `modules/webrtc/webrtc_multiplayer_peer.cpp` | WebRTC実装でのpeer_disconnected発火処理 |

**主要処理フロー**:
1. ネットワーク層で切断イベント検知
2. ピア情報のクリーンアップ
3. `emit_signal(SNAME("peer_disconnected"), peer_id)`でシグナル発火

#### Step 3: 切断メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | multiplayer_peer.cpp | `scene/main/multiplayer_peer.cpp` | 98行目でdisconnect_peerメソッドがバインドされている |

**主要処理フロー**:
- **125行目**: `ADD_SIGNAL(MethodInfo("peer_disconnected", PropertyInfo(Variant::INT, "id")));`

### プログラム呼び出し階層図

```
ネットワークプロトコル層（ENet/WebSocket/WebRTC）
    │
    ├─ poll() / _process_poll()
    │      └─ 切断イベント検知
    │
    ├─ disconnect_peer(peer_id, force)
    │      └─ 明示的な切断処理
    │
    └─ emit_signal("peer_disconnected", peer_id)
           │
           └─ 接続されたシグナルハンドラ
                  └─ クリーンアップ処理
```

### データフロー図

```
[入力]                    [処理]                              [出力]

切断イベント       ───▶ MultiplayerPeer実装         ───▶ peer_disconnectedシグナル
(正常/タイムアウト)        (ENet/WS/WebRTC)                      │
                                │                               ▼
                                ▼                    シグナルハンドラ呼び出し
                         ピア情報削除                          │
                                                              ▼
                                                    リソースクリーンアップ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| multiplayer_peer.cpp | `scene/main/multiplayer_peer.cpp` | ソース | シグナル定義・基底クラス実装 |
| multiplayer_peer.h | `scene/main/multiplayer_peer.h` | ソース | MultiplayerPeerクラス定義 |
| multiplayer_api.cpp | `scene/main/multiplayer_api.cpp` | ソース | マルチプレイヤーAPI実装 |
| enet_multiplayer_peer.cpp | `modules/enet/enet_multiplayer_peer.cpp` | ソース | ENetプロトコル実装 |
| websocket_multiplayer_peer.cpp | `modules/websocket/websocket_multiplayer_peer.cpp` | ソース | WebSocketプロトコル実装 |
| webrtc_multiplayer_peer.cpp | `modules/webrtc/webrtc_multiplayer_peer.cpp` | ソース | WebRTCプロトコル実装 |
| scene_multiplayer.cpp | `modules/multiplayer/scene_multiplayer.cpp` | ソース | シーンマルチプレイヤー実装 |
