# 通知設計書 66-NOTIFICATION_SORT_CHILDREN

## 概要

本ドキュメントは、Godotエンジンにおける`NOTIFICATION_SORT_CHILDREN`通知の設計仕様を定義する。この通知はContainerクラスで子ノードのソート・レイアウト処理を実行すべきタイミングで送信される内部通知である。

### 本通知の処理概要

`NOTIFICATION_SORT_CHILDREN`通知は、ContainerノードがGUIレイアウトのために子コントロールをソート・再配置するタイミングで発火される。各Containerの派生クラス（BoxContainer、GridContainerなど）はこの通知を受信して、自身のレイアウトアルゴリズムに基づき子コントロールを配置する。

**業務上の目的・背景**：GUIフレームワークにおいて、コンテナは子コントロールを自動的にレイアウトする責務を持つ。この通知により、各コンテナタイプが独自のレイアウトロジック（水平配置、グリッド配置、マージン付き配置など）を実装できる。

**通知の送信タイミング**：NOTIFICATION_PRE_SORT_CHILDRENの直後、Container::_sort_children()メソッド内で送信される。queue_sort()によるスケジューリング後、call_deferredで遅延実行される。

**通知の受信者**：Containerクラスおよびその派生クラス（BoxContainer、GridContainer、MarginContainerなど）。_notificationメソッドで受信して処理する。

**通知内容の概要**：通知値は`51`（Container::NOTIFICATION_SORT_CHILDREN）。追加のパラメータは含まれない。

**期待されるアクション**：受信者は子コントロールのサイズ計算、位置計算、fit_child_in_rect()による配置を実装する。

## 通知種別

アプリ内通知（エンジン内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

Container自身の_notificationメソッドに対して送信される。propagate_notificationは使用しない。

## 通知テンプレート

### エンジン内部通知の場合

| 項目 | 内容 |
|-----|------|
| 通知定数名 | NOTIFICATION_SORT_CHILDREN |
| 通知値 | 51 |
| 定義クラス | Container |

### 通知ペイロード

通知に追加データは含まれない。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_notification | 通知ID（51） | エンジン内部 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| レイアウト更新 | _sort_children実行 | コンテナがツリー内 | queue_sortによるソート実行時 |
| 子追加 | add_child_notify | 子コントロール追加時 | Controlノードが追加された時 |
| 子移動 | move_child_notify | 子ノード順序変更時 | 子ノードの順序が変更された時 |
| 子削除 | remove_child_notify | 子コントロール削除時 | Controlノードが削除された時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ツリー外 | is_inside_tree()がfalseの場合 |
| ソート未スケジュール | pending_sortがfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[NOTIFICATION_PRE_SORT_CHILDREN完了] --> B[NOTIFICATION_SORT_CHILDREN送信]
    B --> C[派生クラスの_notification受信]
    C --> D[レイアウト計算]
    D --> E[fit_child_in_rect呼び出し]
    E --> F[子コントロール配置]
    F --> G[sort_childrenシグナル発火]
    G --> H[pending_sort = false]
    H --> I[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

### 更新テーブル一覧

本通知はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ツリー外呼び出し | ノードがシーンツリーに未参加 | 通知送信前にチェックしスキップ |
| 無効な子ノード | 子ノードがControlでない | as_sortable_controlでフィルタリング |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（フレームレート依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

常時（レイアウト更新時）

## セキュリティ考慮事項

- 本通知はエンジン内部の通知であり、外部からの直接送信は不可能
- レイアウト処理はメインスレッドで実行される

## 備考

- 対となる通知として`NOTIFICATION_PRE_SORT_CHILDREN`（50）がある
- `sort_children`シグナルも同時に発火される
- 各Container派生クラスはこの通知に対してレイアウトロジックを実装する
- fit_child_in_rect()を使用して子コントロールを配置する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知定数の定義場所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | container.h | `scene/gui/container.h` | 65行目でNOTIFICATION_SORT_CHILDRENが51として定義されていることを確認 |

**読解のコツ**: PRE_SORT_CHILDRENとSORT_CHILDRENがペアで定義されている点に注目する。

#### Step 2: エントリーポイントを理解する

通知を発火する_sort_childrenメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | container.cpp | `scene/gui/container.cpp` | 90行目で`notification(NOTIFICATION_SORT_CHILDREN);`が呼び出される |
| 2-2 | container.cpp | `scene/gui/container.cpp` | 91行目で`emit_signal(SceneStringName(sort_children));`でシグナル発火 |

**主要処理フロー**:
1. **87行目**: NOTIFICATION_PRE_SORT_CHILDREN送信
2. **88行目**: pre_sort_childrenシグナル発火
3. **90行目**: `notification(NOTIFICATION_SORT_CHILDREN);`で通知送信
4. **91行目**: `emit_signal(SceneStringName(sort_children));`でシグナル発火
5. **92行目**: `pending_sort = false;`でフラグリセット

#### Step 3: 派生クラスでの利用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | box_container.cpp | `scene/gui/box_container.cpp` | NOTIFICATION_SORT_CHILDRENを受信してレイアウト計算を行う |
| 3-2 | grid_container.cpp | `scene/gui/grid_container.cpp` | グリッドレイアウトの実装 |
| 3-3 | margin_container.cpp | `scene/gui/margin_container.cpp` | マージン付きレイアウトの実装 |

**主要処理フロー**:
- 各派生クラスでNOTIFICATION_SORT_CHILDRENをcase文で処理
- 子コントロールをイテレートしてサイズ・位置を計算
- fit_child_in_rect()で配置を適用

### プログラム呼び出し階層図

```
Container::_sort_children()
    │
    ├─ notification(NOTIFICATION_PRE_SORT_CHILDREN)
    │
    ├─ emit_signal("pre_sort_children")
    │
    ├─ notification(NOTIFICATION_SORT_CHILDREN)
    │      │
    │      └─ 派生クラスの_notification()
    │             │
    │             ├─ BoxContainer: 水平/垂直レイアウト
    │             ├─ GridContainer: グリッドレイアウト
    │             ├─ MarginContainer: マージンレイアウト
    │             └─ その他派生クラス
    │
    └─ emit_signal("sort_children")
```

### データフロー図

```
[入力]                    [処理]                              [出力]

レイアウト変更     ───▶ SORT_CHILDREN通知           ───▶ 派生クラス処理
トリガー                      │                               │
                              ▼                               ▼
                         _notification受信              fit_child_in_rect()
                                                              │
                                                              ▼
                                                    子コントロール配置完了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| container.h | `scene/gui/container.h` | ソース | 通知定数・クラス定義 |
| container.cpp | `scene/gui/container.cpp` | ソース | Container実装・通知発火 |
| box_container.cpp | `scene/gui/box_container.cpp` | ソース | BoxContainerレイアウト実装 |
| grid_container.cpp | `scene/gui/grid_container.cpp` | ソース | GridContainerレイアウト実装 |
| margin_container.cpp | `scene/gui/margin_container.cpp` | ソース | MarginContainerレイアウト実装 |
| center_container.cpp | `scene/gui/center_container.cpp` | ソース | CenterContainerレイアウト実装 |
| flow_container.cpp | `scene/gui/flow_container.cpp` | ソース | FlowContainerレイアウト実装 |
| split_container.cpp | `scene/gui/split_container.cpp` | ソース | SplitContainerレイアウト実装 |
| scroll_container.cpp | `scene/gui/scroll_container.cpp` | ソース | ScrollContainerレイアウト実装 |
