# 通知設計書 7-Logger WARNING

## 概要

本ドキュメントは、GodotエンジンのカスタムLoggerクラスにおけるERROR_TYPE_WARNING通知の設計仕様を記述する。

### 本通知の処理概要

Logger WARNINGは、CoreBind::Loggerクラスを継承したカスタムロガーが_log_errorコールバックで受信する警告タイプの通知である。開発者はGDScriptでLoggerを拡張し、警告通知を独自の方法で処理できる。

**業務上の目的・背景**：ERROR_TYPE_ERRORと同様に、カスタムロガーで警告レベルの通知を独自に処理する必要がある場合がある。例えば、警告のみをファイルに記録する、警告を特定の条件でフィルタリングする、警告の統計を取るなどの用途が想定される。Logger WARNINGは、エンジン内で発生するすべての警告通知をカスタムロガーで受信するためのエラータイプである。

**通知の送信タイミング**：OS::add_logger()で登録されたカスタムLoggerに対して、警告が発生するたびに_log_errorメソッドがERROR_TYPE_WARNINGタイプで呼び出される。WARN_PRINT、push_warningなどで発生する。

**通知の受信者**：OS::add_logger()で登録されたカスタムLoggerインスタンス。GDScriptでLoggerクラスを継承し、_log_errorメソッドをオーバーライドすることで受信できる。

**通知内容の概要**：関数名、ファイル名、行番号、警告コード、警告理由、エディタ通知フラグ、エラータイプ（ERROR_TYPE_WARNING=1）、スクリプトバックトレース配列が渡される。

**期待されるアクション**：カスタムロガーは警告情報を独自の方法で処理する。エラーとは分けて記録する、集計する、特定の警告のみを通知するなどの処理が可能。

## 通知種別

カスタムロガー通知（Logger._log_errorコールバック）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コールバック呼び出し） |
| 優先度 | 中（警告レベル） |
| リトライ | 無 |

### 送信先決定ロジック

- OS::add_logger()で登録されたすべてのLoggerに対して順次通知される
- CompositeLoggerを通じてLoggerBind::log_errorが呼び出される
- p_type引数がERROR_TYPE_WARNING（=1）で渡される

## 通知テンプレート

### コールバックパラメータ

| パラメータ | 型 | 説明 |
|-----------|-----|------|
| p_function | String | 呼び出し元関数名 |
| p_file | String | 呼び出し元ファイルパス |
| p_line | int | 呼び出し元行番号 |
| p_code | String | 警告コード |
| p_rationale | String | 警告理由/詳細説明 |
| p_editor_notify | bool | エディタ通知フラグ |
| p_type | int | エラータイプ（ERROR_TYPE_WARNING=1） |
| p_script_backtraces | TypedArray<ScriptBacktrace> | スクリプトバックトレース |

### 本文テンプレート

カスタムロガーの実装に依存

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| function | 呼び出し元関数名 | 警告マクロ | Yes |
| file | 呼び出し元ファイルパス | 警告マクロ | Yes |
| line | 呼び出し元行番号 | 警告マクロ | Yes |
| code | 警告コード | 警告マクロ | Yes |
| rationale | 警告理由 | 警告マクロ | No |
| editor_notify | エディタ通知フラグ | 警告マクロ | Yes |
| type | エラータイプ | ERROR_TYPE_WARNING | Yes |
| backtraces | スクリプトバックトレース | ScriptServer | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| C++マクロ | WARN_PRINT | Loggerが登録されている場合 | C++警告マクロからの通知 |
| API呼び出し | push_warning() | Loggerが登録されている場合 | GDScriptからの警告出力 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| should_log(true) == false | エラー/警告出力がグローバルで無効化されている場合 |
| Loggerが未登録 | OS::add_logger()で登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[警告発生] --> B[WARN_PRINT呼び出し]
    B --> C[_err_print_error with ERR_HANDLER_WARNING]
    C --> D[OS::print_error呼び出し]
    D --> E[CompositeLogger::log_error]
    E --> F[各Logger::log_error]
    F --> G{LoggerBindか?}
    G -->|Yes| H[LoggerBind::log_error]
    H --> I[各CoreBind::Logger]
    I --> J[_log_errorコールバック]
    J --> K{p_type==WARNING?}
    K -->|Yes| L[カスタム警告処理]
    K -->|No| M[他タイプとして処理]
    L --> N[終了]
    M --> N
    G -->|No| O[標準Logger処理]
    O --> N
```

## データベース参照・更新仕様

該当なし（データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コールバック未実装 | _log_errorがオーバーライドされていない | デフォルト動作（何もしない） |
| カスタムロガーでの例外 | _log_error内でエラー発生 | 再帰呼び出し防止機構により無視 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| レート制限 | なし |
| バッファリング | なし（即時コールバック） |

## セキュリティ考慮事項

- カスタムロガーはすべての警告情報にアクセス可能
- 機密情報を含む警告メッセージの扱いに注意

## 備考

- ERROR_TYPE_WARNINGは列挙値1である
- Logger::ERR_WARNINGとして内部的に処理される
- p_typeパラメータで他のエラータイプと区別する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | core_bind.h | `core/core_bind.h` | ErrorType::ERROR_TYPE_WARNING=1（129行目） |
| 1-2 | logger.h | `core/io/logger.h` | Logger::ERR_WARNING=1（52行目） |

**読解のコツ**: CoreBind::Logger::ERROR_TYPE_WARNINGとLogger::ERR_WARNINGは同じ値（1）で対応している。

#### Step 2: 警告マクロを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | error_macros.h | `core/error/error_macros.h` | WARN_PRINT定義（713-714行目）でERR_HANDLER_WARNING指定 |

#### Step 3: ロガー通知を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logger.cpp | `core/io/logger.cpp` | CompositeLogger::log_error（255-262行目） |

**主要処理フロー**:
- p_type引数がERR_WARNINGとして渡される
- 各ロガーのlog_errorに同じp_typeが伝播

### プログラム呼び出し階層図

```
WARN_PRINT(message) / push_warning()
    │
    └─ _err_print_error(..., ERR_HANDLER_WARNING)
           │
           └─ OS::print_error(..., ERR_WARNING)
                  │
                  └─ CompositeLogger::log_error(..., ERR_WARNING)
                         │
                         └─ LoggerBind::log_error(..., ERR_WARNING)
                                │
                                └─ GDVIRTUAL_CALL(_log_error, ..., ERROR_TYPE_WARNING, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| core_bind.h | `core/core_bind.h` | ソース | ERROR_TYPE_WARNING定義 |
| logger.h | `core/io/logger.h` | ソース | ERR_WARNING定義 |
| error_macros.h | `core/error/error_macros.h` | ソース | WARN_PRINTマクロ |
