# 通知設計書 70-NOTIFICATION_RESET_PHYSICS_INTERPOLATION

## 概要

本ドキュメントは、Godotエンジンにおける`NOTIFICATION_RESET_PHYSICS_INTERPOLATION`通知の設計仕様を定義する。この通知は物理補間（Physics Interpolation / Fixed Timestep Interpolation）をリセットする必要があるときに、ノードおよびその子孫に対して送信される内部通知である。

### 本通知の処理概要

`NOTIFICATION_RESET_PHYSICS_INTERPOLATION`通知は、物理補間機能が有効な環境で、ノードの変換（位置・回転・スケール）を即座に更新し、補間の「前回フレーム」と「現在フレーム」の両方を同じ値にリセットする必要があるときに発火される。これにより、テレポートや急激な位置変更時のスムーズでない補間を防止する。

**業務上の目的・背景**：物理補間は、物理ステップ間のビジュアルを滑らかにするための機能である。しかし、ノードがテレポートしたり、ポーズ状態から復帰したり、シーンに新しく追加された場合、前回位置から現在位置への補間が望ましくない結果を生む。この通知により、そのような状況で補間をリセットし、ノードを即座に正しい位置に表示できる。

**通知の送信タイミング**：Node::reset_physics_interpolation()メソッドが呼び出されたとき、または物理補間モードが変更されたとき、ノードがシーンツリーに追加されたときなどに送信される。

**通知の受信者**：物理補間をサポートするノード（CanvasItem、Node3D、Camera2D、Camera3Dなど）およびその派生クラス。

**通知内容の概要**：通知値は`2001`（Node::NOTIFICATION_RESET_PHYSICS_INTERPOLATION）。追加のパラメータは含まれない。

**期待されるアクション**：受信者は前回変換と現在変換を同期させ、RenderingServerに対して補間リセットを通知する。

## 通知種別

アプリ内通知（エンジン内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

対象ノードに対してpropagate_notificationで送信され、全子孫ノードに伝播される。

## 通知テンプレート

### エンジン内部通知の場合

| 項目 | 内容 |
|-----|------|
| 通知定数名 | NOTIFICATION_RESET_PHYSICS_INTERPOLATION |
| 通知値 | 2001 |
| 定義クラス | Node |

### 通知ペイロード

通知に追加データは含まれない。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_notification | 通知ID（2001） | エンジン内部 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | reset_physics_interpolation() | FTI有効かつツリー内 | 明示的なリセット要求 |
| モード変更 | set_physics_interpolation_mode() | 補間有効化 | 補間モードの変更時 |
| ポーズ復帰 | NOTIFICATION_UNPAUSED | 補間有効 | ポーズ状態からの復帰時 |
| サスペンド復帰 | NOTIFICATION_UNSUSPENDED | 補間有効 | サスペンド状態からの復帰時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| FTI無効 | SceneTree::is_fti_enabled()がfalseの場合 |
| ツリー外 | is_inside_tree()がfalseの場合 |
| 補間無効ノード | is_physics_interpolated()がfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リセットトリガー] --> B{FTI有効?}
    B -->|Yes| C{ツリー内?}
    B -->|No| D[処理終了]
    C -->|Yes| E[propagate_notification]
    C -->|No| D
    E --> F[各ノードの_notification受信]
    F --> G{補間サポート?}
    G -->|Yes| H[前回/現在変換を同期]
    G -->|No| I[処理スキップ]
    H --> J[RenderingServer更新]
    I --> K[処理終了]
    J --> K
    D --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

### 更新テーブル一覧

本通知はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| FTI未有効 | プロジェクト設定で無効 | 通知送信をスキップ |
| 無効なノード | ノードが破棄されている | 処理を安全にスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

常時（補間リセット要求時）

## セキュリティ考慮事項

- 本通知はエンジン内部の通知であり、外部からの直接送信は不可能
- スクリプトからはreset_physics_interpolation()メソッドを通じて間接的にトリガー可能

## 備考

- 通知値2001は「A GodotSpace Odyssey」（2001年宇宙の旅）のパロディとしてコメントされている
- Fixed Timestep Interpolation (FTI)はプロジェクト設定で有効化する
- 自動リセットは_propagate_physics_interpolation_reset_requested()で制御される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知定数の定義場所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node.h | `scene/main/node.h` | 471行目でNOTIFICATION_RESET_PHYSICS_INTERPOLATIONが2001として定義されていることを確認。コメントに「A GodotSpace Odyssey」とある |

**読解のコツ**: 2001という値は2001年宇宙の旅のパロディであり、意図的に選ばれた値である。

#### Step 2: エントリーポイントを理解する

通知を発火するreset_physics_interpolationメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | node.cpp | `scene/main/node.cpp` | 967-976行目のreset_physics_interpolation()メソッドで通知が発火される |

**主要処理フロー**:
1. **968行目**: `if (SceneTree::is_fti_enabled() && is_inside_tree())`でFTI有効とツリー参加をチェック
2. **969行目**: `propagate_notification(NOTIFICATION_RESET_PHYSICS_INTERPOLATION);`で通知送信
3. **975行目**: `_propagate_physics_interpolation_reset_requested(false);`で自動リセットフラグをクリア

#### Step 3: 受信側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | node_3d.cpp | `scene/3d/node_3d.cpp` | 285-291行目でNOTIFICATION_RESET_PHYSICS_INTERPOLATIONを処理 |
| 3-2 | canvas_item.cpp | `scene/main/canvas_item.cpp` | 427行目でNOTIFICATION_RESET_PHYSICS_INTERPOLATIONを処理 |
| 3-3 | camera_2d.cpp | `scene/2d/camera_2d.cpp` | 309-310行目で_reset_physics_interpolation_client()を呼び出し |

**主要処理フロー**:
- Node3D: `_reset_physics_interpolation_client()`を呼び出し、RenderingServerの補間をリセット
- CanvasItem: 2D用の補間リセット処理

### プログラム呼び出し階層図

```
Node
    │
    └─ reset_physics_interpolation()
           │
           ├─ SceneTree::is_fti_enabled() チェック
           │
           ├─ propagate_notification(NOTIFICATION_RESET_PHYSICS_INTERPOLATION)
           │      │
           │      ├─ Node3D::_notification()
           │      │      └─ _reset_physics_interpolation_client()
           │      │             └─ RenderingServer更新
           │      │
           │      ├─ CanvasItem::_notification()
           │      │      └─ 2D補間リセット
           │      │
           │      └─ Camera2D/Camera3D/etc.
           │
           └─ _propagate_physics_interpolation_reset_requested(false)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

リセット要求       ───▶ reset_physics_interpolation() ───▶ propagate_notification
                              │                               │
                              ▼                               ▼
                         FTIチェック              各ノード_notification
                              │                               │
                              ▼                               ▼
                    is_fti_enabled()             _reset_physics_interpolation_client()
                                                              │
                                                              ▼
                                                    RenderingServer更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node.h | `scene/main/node.h` | ソース | 通知定数定義 |
| node.cpp | `scene/main/node.cpp` | ソース | reset_physics_interpolation実装 |
| node_3d.cpp | `scene/3d/node_3d.cpp` | ソース | Node3D補間リセット処理 |
| canvas_item.cpp | `scene/main/canvas_item.cpp` | ソース | CanvasItem補間リセット処理 |
| camera_2d.cpp | `scene/2d/camera_2d.cpp` | ソース | Camera2D補間リセット処理 |
| camera_3d.cpp | `scene/3d/camera_3d.cpp` | ソース | Camera3D補間リセット処理 |
| scene_tree_fti.cpp | `scene/main/scene_tree_fti.cpp` | ソース | FTI実装 |
| visual_instance_3d.cpp | `scene/3d/visual_instance_3d.cpp` | ソース | VisualInstance3D補間処理 |
| cpu_particles_2d.cpp | `scene/2d/cpu_particles_2d.cpp` | ソース | CPUParticles2D補間処理 |
| remote_transform_2d.cpp | `scene/2d/remote_transform_2d.cpp` | ソース | RemoteTransform2D補間処理 |
