# 通知設計書 8-Logger SCRIPT

## 概要

本ドキュメントは、GodotエンジンのカスタムLoggerクラスにおけるERROR_TYPE_SCRIPT通知の設計仕様を記述する。

### 本通知の処理概要

Logger SCRIPTは、CoreBind::Loggerクラスを継承したカスタムロガーが_log_errorコールバックで受信するスクリプトエラータイプの通知である。GDScript、C#、その他のスクリプト言語で発生したエラーを特別に識別して処理できる。

**業務上の目的・背景**：スクリプトエラーはゲーム開発において最も頻繁に発生するエラータイプであり、C++内部エラーとは区別して処理したい場合がある。例えば、スクリプトエラーのみを開発者に通知する、スクリプトエラーの統計を取る、スクリプトエラーをより詳細なフォーマットで出力するなどの用途が想定される。Logger SCRIPTは、スクリプト実行中に発生したエラーをカスタムロガーで受信するためのエラータイプである。

**通知の送信タイミング**：スクリプト実行エンジン（GDScript、Mono等）がエラーを検出したとき、ERR_HANDLER_SCRIPTタイプでエラーが報告され、登録されたカスタムLoggerに通知される。

**通知の受信者**：OS::add_logger()で登録されたカスタムLoggerインスタンス。_log_errorメソッドのp_type引数がERROR_TYPE_SCRIPTの場合にスクリプトエラーと判断できる。

**通知内容の概要**：関数名、ファイル名、行番号、エラーコード、エラー理由、エディタ通知フラグ、エラータイプ（ERROR_TYPE_SCRIPT=2）、スクリプトバックトレース配列が渡される。

**期待されるアクション**：カスタムロガーはスクリプトエラーを独自の方法で処理する。スクリプトエラーのみを別ファイルに記録する、より詳細なスタックトレースを出力する、特定のスクリプトエラーを無視するなどの処理が可能。

## 通知種別

カスタムロガー通知（Logger._log_errorコールバック）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コールバック呼び出し） |
| 優先度 | 高（スクリプトエラーレベル） |
| リトライ | 無 |

### 送信先決定ロジック

- OS::add_logger()で登録されたすべてのLoggerに対して順次通知される
- CompositeLoggerを通じてLoggerBind::log_errorが呼び出される
- p_type引数がERROR_TYPE_SCRIPT（=2）で渡される

## 通知テンプレート

### コールバックパラメータ

| パラメータ | 型 | 説明 |
|-----------|-----|------|
| p_function | String | スクリプト関数名 |
| p_file | String | スクリプトファイルパス |
| p_line | int | スクリプト行番号 |
| p_code | String | エラーコード |
| p_rationale | String | エラー理由/詳細説明 |
| p_editor_notify | bool | エディタ通知フラグ |
| p_type | int | エラータイプ（ERROR_TYPE_SCRIPT=2） |
| p_script_backtraces | TypedArray<ScriptBacktrace> | スクリプトバックトレース |

### 本文テンプレート

カスタムロガーの実装に依存

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| function | スクリプト関数名 | スクリプトエンジン | Yes |
| file | スクリプトファイルパス | スクリプトエンジン | Yes |
| line | スクリプト行番号 | スクリプトエンジン | Yes |
| code | エラーコード | スクリプトエンジン | Yes |
| rationale | エラー理由 | スクリプトエンジン | No |
| editor_notify | エディタ通知フラグ | スクリプトエンジン | Yes |
| type | エラータイプ | ERROR_TYPE_SCRIPT | Yes |
| backtraces | スクリプトバックトレース | ScriptServer | Yes（スクリプトエラーの場合） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スクリプトエンジン | GDScript実行エラー | Loggerが登録されている場合 | GDScriptランタイムエラー |
| スクリプトエンジン | C#実行エラー | Loggerが登録されている場合 | Monoランタイムエラー |
| C++マクロ | ERR_HANDLER_SCRIPT使用 | Loggerが登録されている場合 | 明示的なスクリプトエラー報告 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| should_log(true) == false | エラー出力がグローバルで無効化されている場合 |
| Loggerが未登録 | OS::add_logger()で登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[スクリプトエラー発生] --> B[スクリプトエンジンがエラー報告]
    B --> C[_err_print_error with ERR_HANDLER_SCRIPT]
    C --> D[OS::print_error呼び出し]
    D --> E[CompositeLogger::log_error]
    E --> F[各Logger::log_error]
    F --> G{LoggerBindか?}
    G -->|Yes| H[LoggerBind::log_error]
    H --> I[各CoreBind::Logger]
    I --> J[_log_errorコールバック]
    J --> K{p_type==SCRIPT?}
    K -->|Yes| L[カスタムスクリプトエラー処理]
    K -->|No| M[他タイプとして処理]
    L --> N[終了]
    M --> N
    G -->|No| O[標準Logger処理]
    O --> N
```

## データベース参照・更新仕様

該当なし（データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コールバック未実装 | _log_errorがオーバーライドされていない | デフォルト動作（何もしない） |
| カスタムロガーでの例外 | _log_error内でエラー発生 | 再帰呼び出し防止機構により無視 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| レート制限 | なし |
| バッファリング | なし（即時コールバック） |

## セキュリティ考慮事項

- スクリプトファイルパスが含まれるためプロジェクト構造が露出する
- ユーザー入力に依存するスクリプトエラーの場合、入力内容が露出する可能性
- 本番環境ではスクリプトエラーの詳細出力を制限することを推奨

## 備考

- ERROR_TYPE_SCRIPTは列挙値2である
- Logger::ERR_SCRIPTとして内部的に処理される
- 標準出力では「SCRIPT ERROR:」プレフィックスで表示される
- インデントは10スペース（error_type_indentで定義）
- スクリプトバックトレースが特に重要（呼び出しチェーン全体を含む）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | core_bind.h | `core/core_bind.h` | ErrorType::ERROR_TYPE_SCRIPT=2（130行目） |
| 1-2 | logger.h | `core/io/logger.h` | Logger::ERR_SCRIPT=2（53行目） |
| 1-3 | logger.h | `core/io/logger.h` | error_type_string関数でSCRIPT ERROR文字列（64行目） |
| 1-4 | logger.h | `core/io/logger.h` | error_type_indent関数で10スペース（78行目） |

**読解のコツ**: ERROR_TYPE_SCRIPTは値2で、「SCRIPT ERROR」として出力される。

#### Step 2: スクリプトバックトレースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script_backtrace.h | `core/object/script_backtrace.h` | ScriptBacktraceクラス定義 |

**主要処理フロー**:
- ScriptBacktraceはスクリプト呼び出しスタックを保持
- format()メソッドで整形された文字列を取得

#### Step 3: エラー報告を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | error_macros.h | `core/error/error_macros.h` | ERR_HANDLER_SCRIPT列挙値（45行目） |
| 3-2 | logger.cpp | `core/io/logger.cpp` | log_error実装（58-80行目） |

### プログラム呼び出し階層図

```
[GDScript実行エラー]
    │
    └─ GDScriptFunction::call() でエラー検出
           │
           └─ _err_print_error(..., ERR_HANDLER_SCRIPT)
                  │
                  └─ OS::print_error(..., ERR_SCRIPT)
                         │
                         ├─ Logger::log_error(..., ERR_SCRIPT)
                         │      │
                         │      └─ "SCRIPT ERROR: " プレフィックス出力
                         │
                         └─ LoggerBind::log_error(..., ERR_SCRIPT)
                                │
                                └─ GDVIRTUAL_CALL(_log_error, ..., ERROR_TYPE_SCRIPT, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| core_bind.h | `core/core_bind.h` | ソース | ERROR_TYPE_SCRIPT定義 |
| logger.h | `core/io/logger.h` | ソース | ERR_SCRIPT定義、error_type_string |
| error_macros.h | `core/error/error_macros.h` | ソース | ERR_HANDLER_SCRIPT定義 |
| script_backtrace.h | `core/object/script_backtrace.h` | ソース | ScriptBacktraceクラス |
