# 通知設計書 9-Logger SHADER

## 概要

本ドキュメントは、GodotエンジンのカスタムLoggerクラスにおけるERROR_TYPE_SHADER通知の設計仕様を記述する。

### 本通知の処理概要

Logger SHADERは、CoreBind::Loggerクラスを継承したカスタムロガーが_log_errorコールバックで受信するシェーダエラータイプの通知である。GLSLシェーダ、Godotシェーダ言語、ビジュアルシェーダなどで発生したエラーを特別に識別して処理できる。

**業務上の目的・背景**：シェーダエラーはグラフィックスプログラミングにおいて重要なエラーカテゴリであり、通常のスクリプトエラーやC++エラーとは異なる対応が必要な場合がある。例えば、シェーダエラーのみをグラフィックス担当者に通知する、シェーダコンパイルエラーを詳細に記録する、GPUベンダー固有のエラーを分析するなどの用途が想定される。Logger SHADERは、シェーダ関連のエラーをカスタムロガーで受信するためのエラータイプである。

**通知の送信タイミング**：シェーダコンパイラがエラーを検出したとき、またはシェーダ実行時エラーが発生したとき、ERR_HANDLER_SHADERタイプでエラーが報告され、登録されたカスタムLoggerに通知される。

**通知の受信者**：OS::add_logger()で登録されたカスタムLoggerインスタンス。_log_errorメソッドのp_type引数がERROR_TYPE_SHADERの場合にシェーダエラーと判断できる。

**通知内容の概要**：関数名、ファイル名（シェーダリソースパス）、行番号、エラーコード、エラー理由（コンパイルエラーメッセージなど）、エディタ通知フラグ、エラータイプ（ERROR_TYPE_SHADER=3）、スクリプトバックトレース配列が渡される。

**期待されるアクション**：カスタムロガーはシェーダエラーを独自の方法で処理する。シェーダエラーのみを別ファイルに記録する、GPUベンダー別にエラーを分類する、シェーダエディタと連携するなどの処理が可能。

## 通知種別

カスタムロガー通知（Logger._log_errorコールバック）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コールバック呼び出し） |
| 優先度 | 高（シェーダエラーレベル） |
| リトライ | 無 |

### 送信先決定ロジック

- OS::add_logger()で登録されたすべてのLoggerに対して順次通知される
- CompositeLoggerを通じてLoggerBind::log_errorが呼び出される
- p_type引数がERROR_TYPE_SHADER（=3）で渡される

## 通知テンプレート

### コールバックパラメータ

| パラメータ | 型 | 説明 |
|-----------|-----|------|
| p_function | String | シェーダ処理関数名 |
| p_file | String | シェーダリソースパス |
| p_line | int | シェーダ行番号 |
| p_code | String | エラーコード |
| p_rationale | String | シェーダコンパイルエラーメッセージなど |
| p_editor_notify | bool | エディタ通知フラグ |
| p_type | int | エラータイプ（ERROR_TYPE_SHADER=3） |
| p_script_backtraces | TypedArray<ScriptBacktrace> | スクリプトバックトレース |

### 本文テンプレート

カスタムロガーの実装に依存

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| function | シェーダ処理関数名 | シェーダコンパイラ | Yes |
| file | シェーダリソースパス | シェーダコンパイラ | Yes |
| line | シェーダ行番号 | シェーダコンパイラ | Yes |
| code | エラーコード | シェーダコンパイラ | Yes |
| rationale | コンパイルエラーメッセージ | シェーダコンパイラ | No |
| editor_notify | エディタ通知フラグ | シェーダコンパイラ | Yes |
| type | エラータイプ | ERROR_TYPE_SHADER | Yes |
| backtraces | スクリプトバックトレース | ScriptServer | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| シェーダコンパイラ | GLSLコンパイルエラー | Loggerが登録されている場合 | OpenGLシェーダエラー |
| シェーダコンパイラ | Godotシェーダエラー | Loggerが登録されている場合 | Godotシェーダ言語エラー |
| C++マクロ | ERR_HANDLER_SHADER使用 | Loggerが登録されている場合 | 明示的なシェーダエラー報告 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| should_log(true) == false | エラー出力がグローバルで無効化されている場合 |
| Loggerが未登録 | OS::add_logger()で登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[シェーダエラー発生] --> B[シェーダコンパイラがエラー報告]
    B --> C[_err_print_error with ERR_HANDLER_SHADER]
    C --> D[OS::print_error呼び出し]
    D --> E[CompositeLogger::log_error]
    E --> F[各Logger::log_error]
    F --> G{LoggerBindか?}
    G -->|Yes| H[LoggerBind::log_error]
    H --> I[各CoreBind::Logger]
    I --> J[_log_errorコールバック]
    J --> K{p_type==SHADER?}
    K -->|Yes| L[カスタムシェーダエラー処理]
    K -->|No| M[他タイプとして処理]
    L --> N[終了]
    M --> N
    G -->|No| O[標準Logger処理]
    O --> N
```

## データベース参照・更新仕様

該当なし（データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コールバック未実装 | _log_errorがオーバーライドされていない | デフォルト動作（何もしない） |
| カスタムロガーでの例外 | _log_error内でエラー発生 | 再帰呼び出し防止機構により無視 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| レート制限 | なし |
| バッファリング | なし（即時コールバック） |

## セキュリティ考慮事項

- シェーダリソースパスが含まれるためプロジェクト構造が露出する
- シェーダコードの一部がエラーメッセージに含まれる場合がある
- カスタムシェーダのロジックが露出する可能性

## 備考

- ERROR_TYPE_SHADERは列挙値3である
- Logger::ERR_SHADERとして内部的に処理される
- 標準出力では「SHADER ERROR:」プレフィックスで表示される
- インデントは10スペース（error_type_indentで定義、SCRIPTと同じ）
- シェーダエラーはGPUベンダーによってメッセージ形式が異なる場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | core_bind.h | `core/core_bind.h` | ErrorType::ERROR_TYPE_SHADER=3（131行目） |
| 1-2 | logger.h | `core/io/logger.h` | Logger::ERR_SHADER=3（54行目） |
| 1-3 | logger.h | `core/io/logger.h` | error_type_string関数でSHADER ERROR文字列（66行目） |
| 1-4 | logger.h | `core/io/logger.h` | error_type_indent関数で10スペース（80行目） |

**読解のコツ**: ERROR_TYPE_SHADERは値3で、「SHADER ERROR」として出力される。インデントはSCRIPTと同じ10スペース。

#### Step 2: シェーダエラー報告を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | error_macros.h | `core/error/error_macros.h` | ERR_HANDLER_SHADER列挙値（46行目） |

#### Step 3: ロガー通知を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logger.cpp | `core/io/logger.cpp` | CompositeLogger::log_error（255-262行目） |

### プログラム呼び出し階層図

```
[シェーダコンパイルエラー]
    │
    └─ ShaderCompiler::compile() でエラー検出
           │
           └─ _err_print_error(..., ERR_HANDLER_SHADER)
                  │
                  └─ OS::print_error(..., ERR_SHADER)
                         │
                         ├─ Logger::log_error(..., ERR_SHADER)
                         │      │
                         │      └─ "SHADER ERROR: " プレフィックス出力
                         │
                         └─ LoggerBind::log_error(..., ERR_SHADER)
                                │
                                └─ GDVIRTUAL_CALL(_log_error, ..., ERROR_TYPE_SHADER, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| core_bind.h | `core/core_bind.h` | ソース | ERROR_TYPE_SHADER定義 |
| logger.h | `core/io/logger.h` | ソース | ERR_SHADER定義、error_type_string |
| error_macros.h | `core/error/error_macros.h` | ソース | ERR_HANDLER_SHADER定義 |
