---
generated_at: 2026-01-23 16:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-EditorToaster INFO

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **エディタテーマの背景色補間の詳細計算式**：コード上の0.08という定数の設計根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/gui/editor_toaster.h` 43-47行目 - Severity列挙型定義
- E-02: `editor/gui/editor_toaster.h` 68-86行目 - Toast構造体定義
- E-03: `editor/gui/editor_toaster.h` 91行目 - default_message_duration定数
- E-04: `editor/gui/editor_toaster.h` 67行目 - max_temporary_count定数
- E-05: `editor/gui/editor_toaster.cpp` 439-448行目 - popup_str関数
- E-06: `editor/gui/editor_toaster.cpp` 451-527行目 - _popup_str関数
- E-07: `editor/gui/editor_toaster.cpp` 371-437行目 - popup関数
- E-08: `editor/gui/editor_toaster.cpp` 376-388行目 - severity別スタイル適用
- E-09: `editor/gui/editor_toaster.cpp` 111-141行目 - NOTIFICATION_THEME_CHANGED処理
- E-10: `editor/gui/editor_toaster.cpp` 570-644行目 - コンストラクタ
- E-11: `editor/gui/editor_toaster.cpp` 156-184行目 - _error_handler_impl
- E-12: `doc/classes/EditorToaster.xml` - APIドキュメント
- E-13: `editor/gui/editor_toaster.cpp` 228-272行目 - _auto_hide_or_free_toasts関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SEVERITY_INFOの値は0である | E-01 | ○ |
| C-02 | デフォルトの表示時間は5秒である | E-03 | ○ |
| C-03 | 同時表示上限は5件である | E-04 | ○ |
| C-04 | 保持上限は10件である | E-04, E-13 | ○ |
| C-05 | popup_strはMessageQueue経由で遅延呼び出しされる | E-05 | ○ |
| C-06 | 同一メッセージは重複表示せずカウント増加する | E-06 | ○ |
| C-07 | INFOの場合は境界線なしである | E-08, E-10 | ○ |
| C-08 | 背景色はbase_colorとmono_colorの補間色である | E-09 | ○ |
| C-09 | 補間係数は0.08である | E-09 | △ |
| C-10 | is_processing_errorで再帰呼び出しを防止する | E-05 | ○ |
| C-11 | シングルトンパターンで実装されている | E-10 (singleton変数) | ○ |
| C-12 | エラーハンドラからp_editor_notify=trueで通知される | E-11 | ○ |
| C-13 | Toast構造体はseverity,duration,message等を含む | E-02 | ○ |
| C-14 | popup関数でPanelContainerが作成される | E-07 | ○ |
| C-15 | コピーボタンと閉じるボタンが追加される | E-07 (405-420行目) | ○ |
| C-16 | マウスホバーでタイマーリセットされる | E-05関連の_notification処理 | ○ |
| C-17 | push_toastメソッドがAPIとして公開されている | E-12 | ○ |
| C-18 | StyleBoxFlatで角丸スタイルが適用される | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-09: 補間係数0.08の設計根拠がコード内コメントやドキュメントに記載されていない
  - 候補：デザインガイドライン / UIテーマ設計書 / コミット履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードと整合性が取れている
- 補間係数の設計根拠は視覚的な調整の結果と推測されるが、確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] Severity列挙型のSEVERITY_INFO=0の確認
- [ ] default_message_duration=5.0秒の確認
- [ ] max_temporary_count=5の確認
- [ ] MessageQueue経由の遅延呼び出しの動作確認
- [ ] 同一メッセージのカウント増加動作の確認
