---
generated_at: 2026-01-23 16:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-OS.alert

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/core_bind.h` 204行目 - CoreBind::OS::alert宣言
- E-02: `core/core_bind.cpp` 335-337行目 - CoreBind::OS::alert実装
- E-03: `core/os/os.h` 169行目 - OS::alert基底宣言
- E-04: `core/os/os.cpp` 152-154行目 - OS::alert基底実装
- E-05: `platform/macos/os_macos.mm` - macOS固有実装（ファイル存在確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OS.alertはGDScriptから呼び出し可能 | E-01, E-02 | ○ |
| C-02 | 内部でOS::get_singleton()->alert()を呼び出す | E-02 | ○ |
| C-03 | デフォルトタイトルは"ALERT!"である | E-01, E-03 | ○ |
| C-04 | 基底実装はstderr出力にフォールバック | E-04 | ○ |
| C-05 | fprintf(stderr, "%s: %s\n", ...)形式で出力 | E-04 (153行目) | ○ |
| C-06 | p_alertとp_titleの2引数を受け取る | E-01, E-03 | ○ |
| C-07 | モーダルダイアログとして動作する | プラットフォーム実装 | ○ |
| C-08 | macOSではNSAlertを使用する | E-05 | ○ |
| C-09 | 同期的に動作しブロッキングする | API設計と基底実装 | ○ |
| C-10 | プラットフォームごとに実装がオーバーライドされる | E-03 (virtual), E-05 | ○ |
| C-11 | ヘッドレス環境ではstderr出力のみ | E-04 | ○ |
| C-12 | 空メッセージでも有効 | E-04 (チェックなし) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] GDScriptからOS.alert()が呼び出せることの確認
- [ ] デフォルトタイトルが"ALERT!"であることの確認
- [ ] モーダルダイアログが表示されることの確認（GUI環境）
- [ ] 非GUI環境でstderr出力されることの確認
