---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-StatusIndicator

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **PopupMenu連携時のpressedシグナル非発火**：XMLドキュメントに記載あるが実装確認が必要
  2. **macOSとWindows以外のプラットフォーム動作**：実装ファイル未読込
  3. **レート制限なし**：明示的な制限コードが見当たらないことからの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/status_indicator.h` (行31-65)
- E-02: `scene/main/status_indicator.cpp` (行35-193)
- E-03: `servers/display/display_server.h` (行134-175, 391-399, 868-874)
- E-04: `doc/classes/StatusIndicator.xml` (行1-43)
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` (行12)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StatusIndicatorはNodeを継承する | E-01 (行36-37: `class StatusIndicator : public Node`) | ○ |
| C-02 | macOSとWindowsでのみ実装 | E-04 (行5: `Status indicator is implemented on macOS and Windows`) | ○ |
| C-03 | pressedシグナルが存在する | E-02 (行85: `ADD_SIGNAL(MethodInfo("pressed"...)`) | ○ |
| C-04 | pressedシグナルはmouse_buttonとmouse_positionを持つ | E-02 (行85: `PropertyInfo(Variant::INT, "mouse_button"), PropertyInfo(Variant::VECTOR2I, "mouse_position")`) | ○ |
| C-05 | NOTIFICATION_ENTER_TREEでアイコン作成 | E-02 (行44-55: `case NOTIFICATION_ENTER_TREE:`) | ○ |
| C-06 | NOTIFICATION_EXIT_TREEでアイコン削除 | E-02 (行56-68: `case NOTIFICATION_EXIT_TREE:`) | ○ |
| C-07 | visible, icon, tooltip, menuプロパティが存在 | E-02 (行87-90: `ADD_PROPERTY`) | ○ |
| C-08 | FEATURE_STATUS_INDICATOR機能チェックを行う | E-02 (行45: `has_feature(DisplayServer::FEATURE_STATUS_INDICATOR)`) | ○ |
| C-09 | DisplayServer::create_status_indicatorを呼び出す | E-02 (行47: `DisplayServer::get_singleton()->create_status_indicator`) | ○ |
| C-10 | DisplayServer::delete_status_indicatorを呼び出す | E-02 (行64: `DisplayServer::get_singleton()->delete_status_indicator(iid)`) | ○ |
| C-11 | ERR_MAIN_THREAD_GUARDでメインスレッドチェック | E-02 (行36: `ERR_MAIN_THREAD_GUARD`) | ○ |
| C-12 | is_part_of_edited_scene()チェックが存在 | E-02 (行38-40: `if (is_part_of_edited_scene()) return`) | ○ |
| C-13 | INVALID_INDICATOR_IDとの比較で有効性判定 | E-02 (行46, 58: `iid == DisplayServer::INVALID_INDICATOR_ID`) | ○ |
| C-14 | PopupMenuと連携可能 | E-02 (行48-52: `Object::cast_to<PopupMenu>(get_node_or_null(menu))`) | ○ |
| C-15 | menuプロパティ設定時はpressedシグナル非発火 | E-04 (行24-25: `If this is set, the [signal pressed] signal is not emitted`) | ○ |
| C-16 | get_rect()メソッドでアイコン矩形取得可能 | E-02 (行187-192: `Rect2 StatusIndicator::get_rect()`) | ○ |
| C-17 | _callbackでpressedシグナルを発火 | E-02 (行93-95: `emit_signal(SceneStringName(pressed), p_index, p_pos)`) | ○ |
| C-18 | レート制限は存在しない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レート制限に関する明示的な実装またはドキュメントが見つからない
  - 候補：プラットフォーム固有実装ファイル / プロジェクト設定 / エンジン設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の実装は十分な根拠あり
- 1: 中リスク - プラットフォーム固有実装（macOS/Windows）の詳細は未確認
- 0: 低リスク - APIドキュメントとソースコードの整合性は良好

## 6) レビュアーチェックリスト（最小）
- [ ] C-15（menu設定時のpressedシグナル非発火）の動作を実機で確認
- [ ] macOS固有実装（display_server_macos.mm）の確認
- [ ] Windows固有実装（display_server_windows.cpp）の確認
- [ ] Linux/Web等、未サポートプラットフォームでの動作確認
