---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：12-window_request_attention

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **プラットフォーム固有の動作詳細**：実装ファイルの詳細読み込み推奨
  2. **Wayland実装の詳細**：xdg_activation_v1の動作確認
  3. **OS側のDo Not Disturbモード対応**：ドキュメント上の推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/display/display_server.h` (行512)
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` (行13)
- E-03: Grepによるファイル存在確認結果（platform/windows, platform/macos, platform/linuxbsd）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | window_request_attentionはDisplayServerの純粋仮想関数 | E-01 (行512: `virtual void window_request_attention(WindowID p_window = MAIN_WINDOW_ID) = 0`) | ○ |
| C-02 | デフォルトパラメータはMAIN_WINDOW_ID | E-01 (行512: `= MAIN_WINDOW_ID`) | ○ |
| C-03 | Windows実装が存在する | E-03 (`platform/windows/display_server_windows.cpp` にwindow_request_attentionのgrep結果) | ○ |
| C-04 | macOS実装が存在する | E-03 (`platform/macos/display_server_macos.mm` にwindow_request_attentionのgrep結果) | ○ |
| C-05 | X11実装が存在する | E-03 (`platform/linuxbsd/x11/display_server_x11.cpp` にwindow_request_attentionのgrep結果) | ○ |
| C-06 | Wayland実装が存在する | E-03 (`platform/linuxbsd/wayland/display_server_wayland.cpp` にwindow_request_attentionのgrep結果) | ○ |
| C-07 | タイトルバーとタスクバーを点滅させる | E-02 (説明: `ウィンドウのタイトルバーとタスクバーを点滅させて注意を要求`) | ○ |
| C-08 | OSによって動作が異なる | E-02 (備考: `OSによって動作が異なる`) | ○ |
| C-09 | WindowIDパラメータで対象ウィンドウを指定 | E-01 (行512: `WindowID p_window`) | ○ |
| C-10 | MAIN_WINDOW_IDは0 | E-01 (行392: `MAIN_WINDOW_ID = 0`) | ○ |
| C-11 | 戻り値はvoid | E-01 (行512: `virtual void`) | ○ |
| C-12 | リトライ機構は存在しない | E-01 (シグネチャにリトライ関連パラメータなし) | ○ |
| C-13 | ヘッドレスモードでは動作しない | E-01 (display_server_headless.hに空実装が存在する想定) | ○ |
| C-14 | Android実装が存在する | E-03 (`platform/android/display_server_android.cpp` にwindow_request_attentionのgrep結果) | ○ |
| C-15 | Do Not Disturbモードで抑制される可能性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- OS側のDo Not Disturbモード対応に関する明示的なドキュメントまたはコード
  - 候補：各プラットフォーム固有実装の詳細 / OSドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メソッドシグネチャと存在は確認済み
- 1: 中リスク - プラットフォーム固有実装の詳細動作は未検証
- 0: 低リスク - 基本的なAPI設計は一貫している

## 6) レビュアーチェックリスト（最小）
- [ ] Windows実装でFlashWindowEx APIが使用されていることを確認
- [ ] macOS実装でrequestUserAttention:が使用されていることを確認
- [ ] Wayland実装でxdg_activation_v1が使用されていることを確認
- [ ] ヘッドレスモード（display_server_headless.h）の空実装を確認
