---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-AcceptDialog confirmed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/dialogs.h` (行43-131)
- E-02: `scene/gui/dialogs.cpp` (行31-503)
- E-03: `doc/classes/AcceptDialog.xml` (行1-120)
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` (行14)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AcceptDialogはWindowを継承する | E-01 (行43-44: `class AcceptDialog : public Window`) | ○ |
| C-02 | confirmedシグナルが存在する | E-02 (行430: `ADD_SIGNAL(MethodInfo("confirmed"))`) | ○ |
| C-03 | confirmedシグナルはパラメータを持たない | E-02 (行430: `MethodInfo("confirmed")` - パラメータなし) | ○ |
| C-04 | OKボタンクリックでconfirmedが発火する | E-02 (行497: `ok_button->connect(..._ok_pressed)`, 行140: `emit_signal(SceneStringName(confirmed))`) | ○ |
| C-05 | _ok_pressed()でconfirmedシグナルが発火する | E-02 (行134-142, 行140: `emit_signal(SceneStringName(confirmed))`) | ○ |
| C-06 | hide_on_okプロパティが存在する | E-02 (行181-187: `set_hide_on_ok`, `get_hide_on_ok`) | ○ |
| C-07 | hide_on_okがtrueの場合、OK時にダイアログが非表示になる | E-02 (行135-138: `if (hide_on_ok) { ... set_visible(false); }`) | ○ |
| C-08 | ok_pressed()仮想関数が存在する | E-01 (行85: `virtual void ok_pressed() {}`) | ○ |
| C-09 | set_input_as_handled()が呼ばれる | E-02 (行141: `set_input_as_handled()`) | ○ |
| C-10 | register_text_enter()でLineEditを登録可能 | E-02 (行214-217: `void AcceptDialog::register_text_enter(LineEdit *p_line_edit)`) | ○ |
| C-11 | LineEditでEnter時にOKボタンが無効なら発火しない | E-02 (行122-127: `if (get_ok_button() && get_ok_button()->is_disabled()) return`) | ○ |
| C-12 | ok_button_textプロパティが存在する | E-02 (行205-212, 行427-428) | ○ |
| C-13 | デフォルトタイトルは"Alert!" | E-02 (行499: `set_title(ETR("Alert!"))`) | ○ |
| C-14 | dialog_textプロパティでメッセージを設定可能 | E-02 (行437: `ADD_PROPERTY(..., "dialog_text"...)`) | ○ |
| C-15 | ConfirmationDialogはAcceptDialogを継承 | E-01 (行133-134: `class ConfirmationDialog : public AcceptDialog`) | ○ |
| C-16 | XMLドキュメントに「OKボタンが押された時」と記載 | E-03 (行94-97: `Emitted when the dialog is accepted, i.e. the OK button is pressed.`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり
- 0: 低リスク - ソースコードとXMLドキュメントの整合性良好
- 0: 低リスク - 実装が明確で理解しやすい

## 6) レビュアーチェックリスト（最小）
- [ ] _ok_pressed()の処理フローが設計書通りであることを確認
- [ ] hide_on_okの動作を実機で確認
- [ ] 派生クラスでのok_pressed()オーバーライドの動作確認
