---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-AcceptDialog canceled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/dialogs.h` (行43-131)
- E-02: `scene/gui/dialogs.cpp` (行31-503)
- E-03: `doc/classes/AcceptDialog.xml` (行1-120)
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` (行15)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | canceledシグナルが存在する | E-02 (行431: `ADD_SIGNAL(MethodInfo("canceled"))`) | ○ |
| C-02 | canceledシグナルはパラメータを持たない | E-02 (行431: `MethodInfo("canceled")` - パラメータなし) | ○ |
| C-03 | _cancel_pressed()でcanceledシグナルが発火する | E-02 (行154: `emit_signal(SNAME("canceled"))`) | ○ |
| C-04 | ダイアログの非表示は遅延実行される | E-02 (行152: `callable_mp((Window *)this, &Window::hide).call_deferred()`) | ○ |
| C-05 | cancel_pressed()仮想関数が存在する | E-01 (行86: `virtual void cancel_pressed() {}`) | ○ |
| C-06 | set_input_as_handled()が呼ばれる | E-02 (行161: `set_input_as_handled()`) | ○ |
| C-07 | NOTIFICATION_WM_CLOSE_REQUESTで_cancel_pressed()が呼ばれる | E-02 (行116-118: `case NOTIFICATION_WM_CLOSE_REQUEST: _cancel_pressed()`) | ○ |
| C-08 | close_on_escape設定でEscapeキー動作を制御 | E-02 (行40: `if (close_on_escape && p_event->is_action_pressed(...)`) | ○ |
| C-09 | add_cancel_button()でキャンセルボタンを追加できる | E-02 (行368-378: `Button *AcceptDialog::add_cancel_button`) | ○ |
| C-10 | キャンセルボタンはpressedシグナルで_cancel_pressed()に接続される | E-02 (行376: `b->connect(...callable_mp(this, &AcceptDialog::_cancel_pressed))`) | ○ |
| C-11 | popped_upフラグが使用される | E-02 (行145: `popped_up = false`) | ○ |
| C-12 | parent_visibleの切断処理が行われる | E-02 (行147-150: `if (parent_visible) { parent_visible->disconnect(...) }`) | ○ |
| C-13 | 非排他的ポップアップで親フォーカス時にキャンセルされる | E-02 (行46-49: `if (popped_up && !is_exclusive() && get_flag(FLAG_POPUP)) { _cancel_pressed() }`) | ○ |
| C-14 | close_on_escapeのデフォルトはtrue | E-02 (行59: `bool close_on_escape = true`) in E-01 | ○ |
| C-15 | XMLドキュメントに「閉じられた/キャンセルされた時」と記載 | E-03 (行89-92: `Emitted when the dialog is closed or the button created with add_cancel_button is pressed`) | ○ |
| C-16 | _parent_focused()がparent_visibleのfocus_enteredに接続される | E-02 (行74: `parent_visible->connect(SceneStringName(focus_entered), callable_mp(this, &AcceptDialog::_parent_focused))`) | ○ |
| C-17 | ui_close_dialogアクションが使用される | E-02 (行40: `is_action_pressed(SNAME("ui_close_dialog")...)`) | ○ |
| C-18 | ConfirmationDialogにはデフォルトでキャンセルボタンがある | E-02 (行533: `cancel = add_cancel_button()`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり
- 0: 低リスク - キャンセル経路が明確に実装されている
- 0: 低リスク - ソースコードとXMLドキュメントの整合性良好

## 6) レビュアーチェックリスト（最小）
- [ ] _cancel_pressed()の処理フローが設計書通りであることを確認
- [ ] close_on_escapeの動作を実機で確認
- [ ] 親フォーカスによるキャンセル動作の確認
- [ ] 遅延非表示（call_deferred）の動作確認
