---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-AcceptDialog custom_action

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/dialogs.h` (行43-131)
- E-02: `scene/gui/dialogs.cpp` (行31-503)
- E-03: `doc/classes/AcceptDialog.xml` (行1-120)
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` (行16)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | custom_actionシグナルが存在する | E-02 (行432: `ADD_SIGNAL(MethodInfo("custom_action"...))`) | ○ |
| C-02 | custom_actionシグナルはaction(StringName)パラメータを持つ | E-02 (行432: `PropertyInfo(Variant::STRING_NAME, "action")`) | ○ |
| C-03 | add_button()でカスタムボタンを追加できる | E-02 (行339-366: `Button *AcceptDialog::add_button`) | ○ |
| C-04 | add_button()はp_text, p_right, p_actionパラメータを持つ | E-02 (行339: `add_button(const String &p_text, bool p_right, const String &p_action)`) | ○ |
| C-05 | p_actionが空でない場合のみ_custom_actionに接続される | E-02 (行361-363: `if (!p_action.is_empty()) { button->connect(...) }`) | ○ |
| C-06 | _custom_action()でemit_signalが呼ばれる | E-02 (行328: `emit_signal(SNAME("custom_action"), p_action)`) | ○ |
| C-07 | custom_action()仮想関数が存在する | E-01 (行87: `virtual void custom_action(const String &) {}`) | ○ |
| C-08 | remove_button()でカスタムボタンを削除できる | E-02 (行381-410: `void AcceptDialog::remove_button`) | ○ |
| C-09 | remove_button()で_custom_actionとの接続が解除される | E-02 (行392-394: `if (p_button->is_connected(..._custom_action)) { p_button->disconnect(...) }`) | ○ |
| C-10 | XMLドキュメントに「カスタムボタンが押された時」と記載 | E-03 (行99-103: `Emitted when a custom button with an action is pressed. See add_button.`) | ○ |
| C-11 | add_button()のp_rightパラメータのデフォルトはfalse | E-02 (行419: `DEFVAL(false)`) | ○ |
| C-12 | add_button()のp_actionパラメータのデフォルトは空文字列 | E-02 (行419: `DEFVAL("")`) | ○ |
| C-13 | add_button()はButtonポインタを返す | E-02 (行339, 365: `Button *add_button`, `return button`) | ○ |
| C-14 | callable_mp().bind()でアクション文字列がバインドされる | E-02 (行362: `callable_mp(this, &AcceptDialog::_custom_action).bind(p_action)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり
- 0: 低リスク - 実装がシンプルで理解しやすい
- 0: 低リスク - ソースコードとXMLドキュメントの整合性良好

## 6) レビュアーチェックリスト（最小）
- [ ] p_actionが空の場合にcustom_actionが発火しないことを確認
- [ ] remove_button()後にシグナル接続が解除されていることを確認
- [ ] ダイアログが自動で閉じないことを確認
