---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-NOTIFICATION_ENTER_TREE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` (行449-505)
- E-02: `scene/main/node.cpp` (行60-315, 335-383)
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` (行17)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_ENTER_TREEの値は10 | E-01 (行451: `NOTIFICATION_ENTER_TREE = 10`) | ○ |
| C-02 | ノードがシーンツリーに追加された時に発火する | E-02 (行354: `notification(NOTIFICATION_ENTER_TREE)` in _propagate_enter_tree) | ○ |
| C-03 | _propagate_enter_tree()で通知が伝播する | E-02 (行335-383: `void Node::_propagate_enter_tree()`) | ○ |
| C-04 | data.treeが親のtreeに設定される | E-02 (行339: `data.tree = data.parent->data.tree`) | ○ |
| C-05 | data.depthが親のdepth + 1に設定される | E-02 (行340: `data.depth = data.parent->data.depth + 1`) | ○ |
| C-06 | data.viewportが設定される | E-02 (行345-348: `data.viewport = ...`) | ○ |
| C-07 | グループへの追加が行われる | E-02 (行350-352: `E.value.group = data.tree->add_to_group(...)`) | ○ |
| C-08 | GDVIRTUAL_CALL(_enter_tree)が呼ばれる | E-02 (行356: `GDVIRTUAL_CALL(_enter_tree)`) | ○ |
| C-09 | tree_enteredシグナルが発火する | E-02 (行358: `emit_signal(SceneStringName(tree_entered))`) | ○ |
| C-10 | tree->node_added()が呼ばれる | E-02 (行360: `data.tree->node_added(this)`) | ○ |
| C-11 | 親にchild_entered_treeシグナルが発火する | E-02 (行362-366: `data.parent->emit_signalp(SNAME("child_entered_tree")...)`) | ○ |
| C-12 | 子ノードに再帰的に伝播する | E-02 (行371-376: `K.value->_propagate_enter_tree()` in loop) | ○ |
| C-13 | _notification()でprocess_modeが更新される | E-02 (行113-124: `if (data.process_mode == PROCESS_MODE_INHERIT)...`) | ○ |
| C-14 | _notification()でthread_groupが更新される | E-02 (行126-145: `if (data.process_thread_group == ...)`) | ○ |
| C-15 | _notification()で物理補間モードが更新される | E-02 (行147-153: `if (data.physics_interpolation_mode == ...)`) | ○ |
| C-16 | _notification()でinputグループに追加される | E-02 (行163-174: `add_to_group("_vp_input"...)`) | ○ |
| C-17 | nodes_in_tree_countがインクリメントされる | E-02 (行176: `data.tree->nodes_in_tree_count++`) | ○ |
| C-18 | ルートノードでINHERITの場合PAUSABLEに変更される | E-02 (行118-120: `data.process_mode = PROCESS_MODE_PAUSABLE`) | ○ |
| C-19 | アクセシビリティ更新がトリガーされる | E-02 (行103-111: `data.tree->_accessibility_force_update()`) | ○ |
| C-20 | Object._notificationで受信する | E-03 (備考: `Object._notificationで受信。値=10`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり
- 0: 低リスク - Nodeの基本的なライフサイクル通知として十分に文書化されている
- 0: 低リスク - ソースコードの実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] _propagate_enter_tree()の処理順序が設計書通りであることを確認
- [ ] 子ノードへの再帰伝播が正しく動作することを確認
- [ ] tree_entered/child_entered_treeシグナルの発火タイミングを確認
