---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-NOTIFICATION_EXIT_TREE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` (行449-505)
- E-02: `scene/main/node.cpp` (行186-233, 404-451)
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` (行18)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_EXIT_TREEの値は11 | E-01 (行452: `NOTIFICATION_EXIT_TREE = 11`) | ○ |
| C-02 | ノードがシーンツリーから削除される時に発火する | E-02 (行425: `notification(NOTIFICATION_EXIT_TREE, true)` in _propagate_exit_tree) | ○ |
| C-03 | _propagate_exit_tree()で通知が伝播する | E-02 (行404-451: `void Node::_propagate_exit_tree()`) | ○ |
| C-04 | 子ノードに逆順で再帰する | E-02 (行415-417: `for (HashMap<StringName, Node *>::Iterator I = data.children.last(); I; --I)`) | ○ |
| C-05 | GDVIRTUAL_CALL(_exit_tree)が呼ばれる | E-02 (行421: `GDVIRTUAL_CALL(_exit_tree)`) | ○ |
| C-06 | tree_exitingシグナルが発火する | E-02 (行423: `emit_signal(SceneStringName(tree_exiting))`) | ○ |
| C-07 | 通知がp_reverse=trueで送信される | E-02 (行425: `notification(NOTIFICATION_EXIT_TREE, true)`) | ○ |
| C-08 | tree->node_removed()が呼ばれる | E-02 (行426-428: `data.tree->node_removed(this)`) | ○ |
| C-09 | 親にchild_exiting_treeシグナルが発火する | E-02 (行430-434: `data.parent->emit_signalp(SNAME("child_exiting_tree")...)`) | ○ |
| C-10 | グループから削除される | E-02 (行437-440: `data.tree->remove_from_group(E.key, this)`) | ○ |
| C-11 | data.viewportがnullになる | E-02 (行442: `data.viewport = nullptr`) | ○ |
| C-12 | tree->tree_changed()が呼ばれる | E-02 (行444-446: `data.tree->tree_changed()`) | ○ |
| C-13 | ready_notifiedがfalseになる | E-02 (行448: `data.ready_notified = false`) | ○ |
| C-14 | data.treeがnullになる | E-02 (行449: `data.tree = nullptr`) | ○ |
| C-15 | data.depthが-1になる | E-02 (行450: `data.depth = -1`) | ○ |
| C-16 | _notification()でnodes_in_tree_countがデクリメントされる | E-02 (行203: `data.tree->nodes_in_tree_count--`) | ○ |
| C-17 | _notification()で入力グループから削除される | E-02 (行205-216: `remove_from_group("_vp_input"...)`) | ○ |
| C-18 | _notification()でpath_cacheが削除される | E-02 (行229-232: `memdelete(data.path_cache)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり
- 0: 低リスク - Nodeの基本的なライフサイクル通知として十分に文書化されている
- 0: 低リスク - ソースコードの実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] _propagate_exit_tree()の処理順序が設計書通りであることを確認
- [ ] 子ノードへの逆順再帰伝播が正しく動作することを確認
- [ ] tree_exiting/child_exiting_treeシグナルの発火タイミングを確認
