---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-NOTIFICATION_READY

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` (行449-505)
- E-02: `scene/main/node.cpp` (行249-274, 317-333)
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` (行19)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_READYの値は13 | E-01 (行454: `NOTIFICATION_READY = 13`) | ○ |
| C-02 | ノードの準備完了時に発火する | E-02 (行330: `notification(NOTIFICATION_READY)` in _propagate_ready) | ○ |
| C-03 | _propagate_ready()で通知が伝播する | E-02 (行317-333: `void Node::_propagate_ready()`) | ○ |
| C-04 | ready_notifiedがtrueに設定される | E-02 (行318: `data.ready_notified = true`) | ○ |
| C-05 | 子ノードに再帰する | E-02 (行319-323: `K.value->_propagate_ready()` in loop) | ○ |
| C-06 | POST_ENTER_TREE通知が先に発火する | E-02 (行326: `notification(NOTIFICATION_POST_ENTER_TREE)`) | ○ |
| C-07 | ready_firstがtrueの場合のみREADY通知が発火する | E-02 (行328: `if (data.ready_first)`) | ○ |
| C-08 | ready_firstがfalseに設定される | E-02 (行329: `data.ready_first = false`) | ○ |
| C-09 | readyシグナルが発火する | E-02 (行331: `emit_signal(SceneStringName(ready))`) | ○ |
| C-10 | GDVIRTUAL_CALL(_ready)が呼ばれる | E-02 (行273: `GDVIRTUAL_CALL(_ready)`) | ○ |
| C-11 | _inputオーバーライドチェックが行われる | E-02 (行250-252: `GDVIRTUAL_IS_OVERRIDDEN(_input)`) | ○ |
| C-12 | _processオーバーライドチェックが行われる | E-02 (行266-268: `GDVIRTUAL_IS_OVERRIDDEN(_process)`) | ○ |
| C-13 | _physics_processオーバーライドチェックが行われる | E-02 (行269-271: `GDVIRTUAL_IS_OVERRIDDEN(_physics_process)`) | ○ |
| C-14 | オーバーライドチェック後にset_process()が呼ばれる | E-02 (行267: `set_process(true)`) | ○ |
| C-15 | オーバーライドチェック後にset_physics_process()が呼ばれる | E-02 (行270: `set_physics_process(true)`) | ○ |
| C-16 | Object._notificationで受信する | E-03 (備考: `Object._notificationで受信。値=13`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり
- 0: 低リスク - Nodeの基本的なライフサイクル通知として十分に文書化されている
- 0: 低リスク - ソースコードの実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] _propagate_ready()の処理順序が設計書通りであることを確認
- [ ] ready_firstフラグの動作を確認
- [ ] readyシグナルの発火タイミングを確認
- [ ] オーバーライドチェックによる自動set_process()の動作確認
