---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-NOTIFICATION_PROCESS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` (行449-505)
- E-02: `scene/main/node.cpp` (行91-93)
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` (行20)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_PROCESSの値は17 | E-01 (行458: `NOTIFICATION_PROCESS = 17`) | ○ |
| C-02 | set_process(true)で有効化される | E-01 (行650: `void set_process(bool p_process)`) | ○ |
| C-03 | can_process()でポーズ状態をチェックする | E-01 (行749: `bool can_process() const`) | ○ |
| C-04 | get_process_delta_time()でデルタタイムを取得可能 | E-01 (行651: `double get_process_delta_time() const`) | ○ |
| C-05 | GDVIRTUAL_CALL(_process, delta)が呼ばれる | E-02 (行92: `GDVIRTUAL_CALL(_process, get_process_delta_time())`) | ○ |
| C-06 | 毎フレーム実行される | E-03 (説明: `毎フレーム実行される処理通知`) | ○ |
| C-07 | process_priorityで処理順序を制御可能 | E-01 (行660-661: `set_process_priority`, `get_process_priority`) | ○ |
| C-08 | NOTIFICATION_INTERNAL_PROCESSの値は25 | E-01 (行466: `NOTIFICATION_INTERNAL_PROCESS = 25`) | ○ |
| C-09 | NOTIFICATION_PHYSICS_PROCESSの値は16 | E-01 (行457: `NOTIFICATION_PHYSICS_PROCESS = 16`) | ○ |
| C-10 | _processオーバーライドでset_process(true)が自動呼び出し | E-02 (行266-268 in NOTIFICATION_READY: `GDVIRTUAL_IS_OVERRIDDEN(_process) -> set_process(true)`) | ○ |
| C-11 | is_processing()で状態を確認可能 | E-01 (行652: `bool is_processing() const`) | ○ |
| C-12 | ProcessModeで動作を制御可能 | E-01 (行75-81: `enum ProcessMode`) | ○ |
| C-13 | GDVIRTUAL1マクロで_processが定義されている | E-01 (行427: `GDVIRTUAL1(_process, double)`) | ○ |
| C-14 | Object._notificationで受信する | E-03 (備考: `Object._notificationで受信。値=17`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり
- 0: 低リスク - Nodeの基本的なフレーム更新通知として十分に文書化されている
- 0: 低リスク - ソースコードの実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] set_process()の動作を確認
- [ ] process_priorityによる処理順序を確認
- [ ] can_process()によるポーズ状態での動作を確認
- [ ] get_process_delta_time()の値を確認
