---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-NOTIFICATION_PAUSED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **ネットワーク通信の一時停止処理**：コード内に明示的な実装根拠なし
  2. **マルチスレッド環境でのメインスレッド制限**：一部推測を含む

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 75-81行目 - ProcessMode enum定義
- E-02: `scene/main/node.h` 455行目 - NOTIFICATION_PAUSED = 14
- E-03: `scene/main/node.cpp` 235-240行目 - _notification内のPAUSEDケース処理
- E-04: `scene/main/node.cpp` 663-719行目 - set_process_mode関数
- E-05: `scene/main/node.cpp` 721-736行目 - _propagate_pause_notification関数
- E-06: `scene/main/node.cpp` 694-698行目 - pause_notification判定ロジック
- E-07: `scene/main/node.cpp` 906-933行目 - _can_process関数
- E-08: `scene/main/node.h` 227-228行目 - Data構造体のprocess_owner
- E-09: `scene/main/node.cpp` 3944行目 - BIND_CONSTANT(NOTIFICATION_PAUSED)
- E-10: `scene/audio/audio_stream_player_internal.cpp` - オーディオポーズ処理
- E-11: `scene/gui/video_stream_player.cpp` - ビデオポーズ処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_PAUSEDの値は14である | E-02 | ○ |
| C-02 | ポーズ時に物理補間がリセットされる | E-03 | ○ |
| C-03 | prev_can_process && !next_can_processでPAUSED通知が発火 | E-06 | ○ |
| C-04 | PROCESS_MODE_ALWAYSのノードには送信されない | E-07 | ○ |
| C-05 | PROCESS_MODE_WHEN_PAUSEDのノードには送信されない | E-07 | ○ |
| C-06 | 子ノードへの伝播は_propagate_pause_notificationで行われる | E-05 | ○ |
| C-07 | process_modeがINHERITの場合は親のprocess_ownerを参照 | E-04, E-08 | ○ |
| C-08 | ProcessModeには5つの状態がある | E-01 | ○ |
| C-09 | SceneTree.paused設定時に全ノードに伝播される | E-05 | ○ |
| C-10 | NOTIFICATION_SUSPENDEDと同じcase文で処理される | E-03 | ○ |
| C-11 | GDScriptからBIND_CONSTANTでアクセス可能 | E-09 | ○ |
| C-12 | set_process_mode()でprocess_mode変更時に通知判定 | E-04 | ○ |
| C-13 | is_inside_tree() == falseの場合は通知されない | E-03, E-04 | ○ |
| C-14 | オーディオプレイヤーでポーズ処理が実装されている | E-10 | ○ |
| C-15 | ビデオプレイヤーでポーズ処理が実装されている | E-11 | ○ |
| C-16 | TOOLS_ENABLEDでtree_process_mode_changedシグナル発行 | E-04 | ○ |
| C-17 | ネットワーク通信の一時停止が期待される | **根拠なし** | △ |
| C-18 | マルチスレッド環境ではメインスレッドからのみ安全 | E-04（部分的） | △ |

## 4) 不足情報（Unknown / Missing）
- ネットワーク通信の一時停止処理については、NOTIFICATION_PAUSEDのハンドラとしての明示的な実装が見つからなかった
  - 候補：modules/multiplayer / scene/main/multiplayer_api.cpp / networking関連コード
- マルチスレッド安全性については、ERR_THREAD_GUARDマクロの存在は確認したが、詳細なスレッドセーフティドキュメントは未確認
  - 候補：core/os/thread.h / core/config/engine.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（14）の正確性 - 低リスク
- 0: 物理補間リセット処理 - 低リスク
- 1: ネットワーク関連の期待されるアクション - 中リスク（実装確認必要）
- 0: GDScriptからのアクセス方法 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_PAUSED = 14 の値が正しいか確認
- [ ] _propagate_pause_notificationの伝播ロジックが正しいか確認
- [ ] ProcessModeの各状態での挙動が正確に記載されているか確認
- [ ] ネットワーク通信の一時停止に関する記述の要否を判断
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
