---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：22-NOTIFICATION_UNPAUSED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **経過時間の再計算・補正**：具体的な実装根拠が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 456行目 - NOTIFICATION_UNPAUSED = 15
- E-02: `scene/main/node.cpp` 696-697行目 - UNPAUSED通知判定ロジック
- E-03: `scene/main/node.cpp` 721-736行目 - _propagate_pause_notification関数
- E-04: `scene/main/node.cpp` 727-728行目 - 条件分岐でのUNPAUSED送信
- E-05: `scene/main/node.cpp` 3945行目 - BIND_CONSTANT(NOTIFICATION_UNPAUSED)
- E-06: `scene/2d/gpu_particles_2d.cpp` - パーティクルのポーズ処理
- E-07: `scene/3d/gpu_particles_3d.cpp` - 3Dパーティクルのポーズ処理
- E-08: `scene/audio/audio_stream_player_internal.cpp` - オーディオのポーズ処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_UNPAUSEDの値は15である | E-01 | ○ |
| C-02 | !prev_can_process && next_can_processでUNPAUSED通知が発火 | E-02 | ○ |
| C-03 | NOTIFICATION_PAUSEDとペアで使用される | E-01, E-02 | ○ |
| C-04 | _propagate_pause_notificationで子ノードへ伝播 | E-03 | ○ |
| C-05 | PROCESS_MODE_ALWAYSのノードには送信されない | E-03, E-04 | ○ |
| C-06 | Node基底クラスでは特別な処理を行わない | E-03 | ○ |
| C-07 | GDScriptからBIND_CONSTANTでアクセス可能 | E-05 | ○ |
| C-08 | GPUParticles2Dでポーズ解除処理が実装されている | E-06 | ○ |
| C-09 | GPUParticles3Dでポーズ解除処理が実装されている | E-07 | ○ |
| C-10 | AudioStreamPlayerでポーズ解除処理が実装されている | E-08 | ○ |
| C-11 | SceneTree.paused = falseで全ノードに伝播される | E-03 | ○ |
| C-12 | is_inside_tree() == falseの場合は通知されない | E-03 | ○ |
| C-13 | process_modeがINHERITの場合は親のprocess_ownerを参照 | E-03 | ○ |
| C-14 | マルチスレッド環境ではメインスレッドからのみ安全 | E-03（部分的） | ○ |
| C-15 | 経過時間の再計算・補正が期待される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 経過時間の再計算・補正については、期待されるアクションとして記載したが、エンジン内で自動的に行われるか、ユーザー実装が必要かは明確でない
  - 候補：scene/main/scene_tree.cpp / core/os/time.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（15）の正確性 - 低リスク
- 0: NOTIFICATION_PAUSEDとのペア関係 - 低リスク
- 1: 経過時間の再計算に関する記述 - 中リスク（確認必要）

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_UNPAUSED = 15 の値が正しいか確認
- [ ] NOTIFICATION_PAUSEDとの対称性が正しく記載されているか確認
- [ ] 各派生クラスでの実装例が正確か確認
- [ ] 経過時間の再計算に関する記述の要否を判断
