---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-NOTIFICATION_PARENTED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 459行目 - NOTIFICATION_PARENTED = 18
- E-02: `scene/main/node.cpp` 1687行目 - notification(NOTIFICATION_PARENTED)送信
- E-03: `scene/main/node.cpp` 1679行目 - p_child->data.parent = this
- E-04: `scene/main/node.cpp` 1689-1691行目 - _set_tree条件判定
- E-05: `scene/main/node.cpp` 1699-1709行目 - add_childバリデーション
- E-06: `scene/main/node.cpp` 1652-1697行目 - _add_child_nocheck関数
- E-07: `scene/main/node.cpp` 3948行目 - BIND_CONSTANT(NOTIFICATION_PARENTED)
- E-08: `scene/main/canvas_item.cpp` 444-449行目 - CanvasItemでのPARENTED処理
- E-09: `scene/2d/physics/collision_shape_2d.cpp` - CollisionShape2DでのPARENTED処理
- E-10: `scene/3d/physics/collision_shape_3d.cpp` - CollisionShape3DでのPARENTED処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_PARENTEDの値は18である | E-01 | ○ |
| C-02 | notification(NOTIFICATION_PARENTED)は_add_child_nocheck内で送信される | E-02 | ○ |
| C-03 | 通知前にdata.parentが設定される | E-03 | ○ |
| C-04 | 親がツリー内の場合のみ_set_treeが実行される | E-04 | ○ |
| C-05 | add_childで自己追加チェックが行われる | E-05 | ○ |
| C-06 | add_childで既存親チェックが行われる | E-05 | ○ |
| C-07 | add_childで循環参照チェックが行われる（DEBUG_ENABLED） | E-05 | ○ |
| C-08 | NOTIFICATION_ENTER_TREEよりも前に発火する | E-02, E-04 | ○ |
| C-09 | GDScriptからBIND_CONSTANTでアクセス可能 | E-07 | ○ |
| C-10 | CanvasItemで_notify_transform()が呼ばれる | E-08 | ○ |
| C-11 | CollisionShape2DでPARENTED処理が実装されている | E-09 | ○ |
| C-12 | CollisionShape3DでPARENTED処理が実装されている | E-10 | ○ |
| C-13 | メインスレッドからのみ子ノード追加が許可される（ツリー内） | E-05 | ○ |
| C-14 | data.blocked > 0の場合はエラーとなる | E-05 | ○ |
| C-15 | add_sibling内部でadd_childが使用される | E-06（行1730参照） | ○ |
| C-16 | この通知時点ではget_tree()がnullを返す可能性がある | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張にソースコードからの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（18）の正確性 - 低リスク
- 0: 送信タイミングの正確性 - 低リスク
- 0: バリデーションロジックの正確性 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_PARENTED = 18 の値が正しいか確認
- [ ] _add_child_nocheck内での通知送信順序が正確か確認
- [ ] NOTIFICATION_ENTER_TREEとの送信順序関係が正しいか確認
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
