---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-NOTIFICATION_UNPARENTED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/node.h` 460行目 - NOTIFICATION_UNPARENTED = 19
- E-02: `scene/main/node.cpp` 1755行目 - notification(NOTIFICATION_UNPARENTED)送信
- E-03: `scene/main/node.cpp` 1752行目 - _set_tree(nullptr)
- E-04: `scene/main/node.cpp` 1763行目 - p_child->data.parent = nullptr
- E-05: `scene/main/node.cpp` 1735-1772行目 - remove_child関数全体
- E-06: `scene/main/node.cpp` 3949行目 - BIND_CONSTANT(NOTIFICATION_UNPARENTED)
- E-07: `scene/2d/physics/collision_shape_2d.cpp` - CollisionShape2DでのUNPARENTED処理
- E-08: `scene/3d/physics/collision_shape_3d.cpp` - CollisionShape3DでのUNPARENTED処理
- E-09: `scene/3d/skeleton_modifier_3d.cpp` - SkeletonModifier3DでのUNPARENTED処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_UNPARENTEDの値は19である | E-01 | ○ |
| C-02 | notification(NOTIFICATION_UNPARENTED)はremove_child内で送信される | E-02 | ○ |
| C-03 | _set_tree(nullptr)の後にUNPARENTED通知が送信される | E-02, E-03 | ○ |
| C-04 | UNPARENTED通知後にdata.parentがnullptrに設定される | E-02, E-04 | ○ |
| C-05 | NOTIFICATION_EXIT_TREEの後に発火する | E-03, E-05 | ○ |
| C-06 | NOTIFICATION_PARENTEDとペアで使用される | E-01, E-06 | ○ |
| C-07 | GDScriptからBIND_CONSTANTでアクセス可能 | E-06 | ○ |
| C-08 | この通知時点ではdata.parentはまだ設定されている | E-02, E-04 | ○ |
| C-09 | この通知時点ではget_tree()はnullを返す | E-03 | ○ |
| C-10 | CollisionShape2DでUNPARENTED処理が実装されている | E-07 | ○ |
| C-11 | CollisionShape3DでUNPARENTED処理が実装されている | E-08 | ○ |
| C-12 | SkeletonModifier3DでUNPARENTED処理が実装されている | E-09 | ○ |
| C-13 | メインスレッドからのみ子ノード削除が許可される（ツリー内） | E-05 | ○ |
| C-14 | data.blocked > 0の場合はエラーとなる | E-05 | ○ |
| C-15 | remove_child_notify仮想関数が呼ばれる | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張にソースコードからの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（19）の正確性 - 低リスク
- 0: 送信タイミングの正確性 - 低リスク
- 0: NOTIFICATION_EXIT_TREEとの順序関係 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_UNPARENTED = 19 の値が正しいか確認
- [ ] remove_child内での通知送信順序が正確か確認
- [ ] data.parentの設定タイミングが正しいか確認
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
