---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-NOTIFICATION_POSTINITIALIZE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/object/object.h` 855行目 - NOTIFICATION_POSTINITIALIZE = 0
- E-02: `core/object/object.cpp` 328-333行目 - _postinitialize関数
- E-03: `core/object/object.cpp` 332行目 - notification(NOTIFICATION_POSTINITIALIZE)
- E-04: `core/object/object.cpp` 329-331行目 - signal_mutex初期化
- E-05: `core/object/object.h` 642行目 - signal_mutexメンバ変数
- E-06: `core/object/object.cpp` 2072行目 - BIND_CONSTANT(NOTIFICATION_POSTINITIALIZE)
- E-07: `scene/main/node.cpp` - NodeでのPOSTINITIALIZE処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_POSTINITIALIZEの値は0である | E-01 | ○ |
| C-02 | _postinitialize()内でnotification()が呼ばれる | E-02, E-03 | ○ |
| C-03 | _uses_signal_mutex()がtrueの場合にsignal_mutexが初期化される | E-04 | ○ |
| C-04 | signal_mutexはMutex*型である | E-05 | ○ |
| C-05 | すべてのObjectインスタンスに送信される | E-02 | ○ |
| C-06 | GDScriptからBIND_CONSTANTでアクセス可能 | E-06 | ○ |
| C-07 | Nodeの場合、NOTIFICATION_ENTER_TREEよりも前に発火する | E-07 | ○ |
| C-08 | コンストラクタ完了後に呼ばれる | E-02 | ○ |
| C-09 | 仮想関数が正しく動作する状態で呼ばれる | E-02 | ○ |
| C-10 | postinitialize_handlerから呼ばれる | E-02 | ○ |
| C-11 | 通知ID = 0で最も基本的な通知である | E-01 | ○ |
| C-12 | NodeでPOSTINITIALIZE処理が実装されている | E-07 | ○ |
| C-13 | すべてのObject派生クラスで利用可能 | E-01, E-02 | ○ |
| C-14 | スクリプトの初期化にも使用される | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張にソースコードからの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（0）の正確性 - 低リスク
- 0: _postinitialize()の処理順序 - 低リスク
- 0: signal_mutex初期化条件 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_POSTINITIALIZE = 0 の値が正しいか確認
- [ ] _postinitialize()の処理順序が正確か確認
- [ ] signal_mutex初期化の条件分岐が正しいか確認
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
