---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-NOTIFICATION_PREDELETE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/object/object.h` 856行目 - NOTIFICATION_PREDELETE = 1
- E-02: `core/object/object.cpp` 273-316行目 - _predelete関数
- E-03: `core/object/object.cpp` 275行目 - notification(NOTIFICATION_PREDELETE, true)
- E-04: `core/object/object.cpp` 274行目 - _predelete_ok = true
- E-05: `core/object/object.cpp` 276-278行目 - _predelete_okチェック
- E-06: `core/object/object.cpp` 318-320行目 - cancel_free関数
- E-07: `core/object/object.cpp` 280行目 - _gdtype_ptr = nullptr
- E-08: `core/object/object.cpp` 281行目 - NOTIFICATION_PREDELETE_CLEANUP
- E-09: `core/object/object.cpp` 285-288行目 - script_instance削除
- E-10: `core/object/object.cpp` 2073行目 - BIND_CONSTANT(NOTIFICATION_PREDELETE)
- E-11: `scene/main/node.cpp` - NodeでのPREDELETE処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_PREDELETEの値は1である | E-01 | ○ |
| C-02 | _predelete()内でnotification()が呼ばれる | E-02, E-03 | ○ |
| C-03 | p_reversed = trueで送信される | E-03 | ○ |
| C-04 | _predelete_okがtrueに設定される | E-04 | ○ |
| C-05 | _predelete_okがfalseなら削除キャンセル | E-05 | ○ |
| C-06 | cancel_free()で_predelete_okをfalseに設定 | E-06 | ○ |
| C-07 | NOTIFICATION_PREDELETE後に_gdtype_ptrがnullptrに設定 | E-07 | ○ |
| C-08 | NOTIFICATION_PREDELETE_CLEANUPが内部用として存在 | E-08 | ○ |
| C-09 | script_instanceがmemdeleteで削除される | E-09 | ○ |
| C-10 | GDScriptからBIND_CONSTANTでアクセス可能 | E-10 | ○ |
| C-11 | NodeでPREDELETE処理が実装されている | E-11 | ○ |
| C-12 | すべてのObjectインスタンスの削除時に送信される | E-02 | ○ |
| C-13 | predelete_handler経由で呼ばれる | E-02 | ○ |
| C-14 | 派生クラスから基底クラスの順で処理される | E-03 | ○ |
| C-15 | _extensionの削除が行われる | E-02 | ○ |
| C-16 | NOTIFICATION_POSTINITIALIZEの次の通知ID | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張にソースコードからの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（1）の正確性 - 低リスク
- 0: _predelete()の処理順序 - 低リスク
- 0: cancel_free()の動作 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_PREDELETE = 1 の値が正しいか確認
- [ ] _predelete()の処理順序が正確か確認
- [ ] cancel_free()による削除キャンセルの動作が正しいか確認
- [ ] p_reversed = trueの効果が正しく記載されているか確認
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
