---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：27-NOTIFICATION_EXTENSION_RELOADED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **署名検証による不正拡張防止**：実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/object/object.h` 857行目 - NOTIFICATION_EXTENSION_RELOADED = 2
- E-02: `core/extension/gdextension.cpp` 1068行目 - notification(NOTIFICATION_EXTENSION_RELOADED)
- E-03: `core/extension/gdextension.cpp` 1030-1074行目 - _finish_reload関数
- E-04: `core/extension/gdextension.cpp` 1032-1043行目 - reset_internal_extension呼び出し
- E-05: `core/extension/gdextension.cpp` 1054-1056行目 - プロパティ復元
- E-06: `core/extension/gdextension.cpp` 1071-1072行目 - instance_stateクリア
- E-07: `core/object/object.cpp` 2074行目 - BIND_CONSTANT(NOTIFICATION_EXTENSION_RELOADED)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_EXTENSION_RELOADEDの値は2である | E-01 | ○ |
| C-02 | _finish_reload内でnotification()が呼ばれる | E-02, E-03 | ○ |
| C-03 | 状態復元後に通知が送信される | E-03, E-05 | ○ |
| C-04 | reset_internal_extensionが呼ばれる | E-04 | ○ |
| C-05 | 保存されたプロパティがobj->set()で復元される | E-05 | ○ |
| C-06 | 通知後にinstance_stateがクリアされる | E-06 | ○ |
| C-07 | GDScriptからBIND_CONSTANTでアクセス可能 | E-07 | ○ |
| C-08 | エディタビルド（TOOLS_ENABLED）でのみ有効 | E-03 | ○ |
| C-09 | オブジェクト消失時はスキップされる | E-03 | ○ |
| C-10 | GDExtensionクラス専用の通知である | E-02 | ○ |
| C-11 | プレースホルダー拡張でも通知が送信される | E-04 | ○ |
| C-12 | NOTIFICATION_PREDELETEの次の通知ID | E-01 | ○ |
| C-13 | extension_reloading_enabledで制御される | E-03（部分的） | ○ |
| C-14 | 署名検証による不正拡張防止がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 署名検証機能については、セキュリティ考慮事項として記載したが、具体的な実装の確認ができていない
  - 候補：core/extension/gdextension_manager.cpp / core/crypto/

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（2）の正確性 - 低リスク
- 0: _finish_reload()の処理順序 - 低リスク
- 1: 署名検証に関する記述 - 中リスク（確認必要）

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_EXTENSION_RELOADED = 2 の値が正しいか確認
- [ ] _finish_reload()の処理順序が正確か確認
- [ ] TOOLS_ENABLEDの条件が正しいか確認
- [ ] 署名検証に関する記述の要否を判断
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
