---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-NOTIFICATION_DRAW

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/canvas_item.h` 211行目 - NOTIFICATION_DRAW = 30
- E-02: `scene/main/canvas_item.cpp` 148行目 - notification(NOTIFICATION_DRAW)
- E-03: `scene/main/canvas_item.cpp` 133-157行目 - _redraw_callback関数
- E-04: `scene/main/canvas_item.cpp` 472-484行目 - queue_redraw関数
- E-05: `scene/main/canvas_item.cpp` 43-44行目 - ERR_DRAW_GUARDマクロ
- E-06: `scene/main/canvas_item.cpp` 149行目 - emit_signal(draw)
- E-07: `scene/main/canvas_item.cpp` 150行目 - GDVIRTUAL_CALL(_draw)
- E-08: `scene/main/canvas_item.h` 108行目 - pending_updateフラグ
- E-09: `scene/main/canvas_item.h` 111行目 - drawingフラグ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_DRAWの値は30である | E-01 | ○ |
| C-02 | _redraw_callback内でnotification()が呼ばれる | E-02, E-03 | ○ |
| C-03 | queue_redraw()でpending_updateがtrueに設定される | E-04 | ○ |
| C-04 | is_inside_tree()がfalseの場合は処理されない | E-04 | ○ |
| C-05 | is_visible_in_tree()がfalseの場合は描画されない | E-03 | ○ |
| C-06 | ERR_DRAW_GUARDで描画コンテキスト外の呼び出しが防止される | E-05 | ○ |
| C-07 | drawシグナルが発行される | E-06 | ○ |
| C-08 | _draw()仮想関数が呼ばれる | E-07 | ○ |
| C-09 | drawing = true時のみdraw_*が呼び出し可能 | E-05, E-03 | ○ |
| C-10 | pending_updateは描画完了後にfalseに設定される | E-03 | ○ |
| C-11 | call_deferredで遅延実行される | E-04 | ○ |
| C-12 | CanvasItem派生クラスで使用される | E-01 | ○ |
| C-13 | current_item_drawnで描画中アイテムを取得可能 | E-03 | ○ |
| C-14 | canvas_item_clear()でコマンドがクリアされる | E-03 | ○ |
| C-15 | draw_commands_dirtyがtrue時にクリアされる | E-03 | ○ |
| C-16 | TextServerのオーバーサンプリングが設定される | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張にソースコードからの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（30）の正確性 - 低リスク
- 0: _redraw_callback()の処理順序 - 低リスク
- 0: ERR_DRAW_GUARDの動作 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_DRAW = 30 の値が正しいか確認
- [ ] _redraw_callback()の処理順序が正確か確認
- [ ] queue_redraw()のcall_deferred動作が正しいか確認
- [ ] ERR_DRAW_GUARDの保護範囲が正しいか確認
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
