---
generated_at: 2026-01-23 11:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-NOTIFICATION_VISIBILITY_CHANGED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/canvas_item.h` 212行目 - NOTIFICATION_VISIBILITY_CHANGED = 31
- E-02: `scene/main/canvas_item.cpp` 94行目 - notification(NOTIFICATION_VISIBILITY_CHANGED)
- E-03: `scene/main/canvas_item.cpp` 76-90行目 - set_visible関数
- E-04: `scene/main/canvas_item.cpp` 92-111行目 - _handle_visibility_change関数
- E-05: `scene/main/canvas_item.cpp` 67-74行目 - _propagate_visibility_changed関数
- E-06: `scene/main/canvas_item.cpp` 433-437行目 - _notification内のVISIBILITY_CHANGEDケース
- E-07: `scene/main/canvas_item.h` 106-107行目 - visible、parent_visible_in_treeフラグ
- E-08: `scene/main/canvas_item.cpp` 62-65行目 - is_visible_in_tree関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_VISIBILITY_CHANGEDの値は31である | E-01 | ○ |
| C-02 | _handle_visibility_change内でnotification()が呼ばれる | E-02, E-04 | ○ |
| C-03 | set_visible()でvisible状態がチェックされる | E-03 | ○ |
| C-04 | parent_visible_in_treeが考慮される | E-03, E-04 | ○ |
| C-05 | _propagate_visibility_changed()で子ノードに伝播される | E-05 | ○ |
| C-06 | visibility_changedシグナルが発行される | E-06 | ○ |
| C-07 | RenderingServer::canvas_item_set_visible()が呼ばれる | E-04 | ○ |
| C-08 | visible時にqueue_redraw()が呼ばれる | E-04 | ○ |
| C-09 | hidden時にhiddenシグナルが発行される | E-04 | ○ |
| C-10 | is_visible_in_tree()はvisible && parent_visible_in_tree | E-08 | ○ |
| C-11 | show()とhide()はset_visible()を呼ぶ | E-03 | ○ |
| C-12 | メインスレッドからのみ変更可能 | E-03 | ○ |
| C-13 | visible状態が同じなら処理されない | E-03 | ○ |
| C-14 | ENTER_TREE時に可視なら通知が送信される | E-06 | ○ |
| C-15 | CanvasItem派生クラスで使用される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張にソースコードからの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（31）の正確性 - 低リスク
- 0: set_visible()の処理順序 - 低リスク
- 0: 伝播メカニズムの正確性 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_VISIBILITY_CHANGED = 31 の値が正しいか確認
- [ ] set_visible()の処理フローが正確か確認
- [ ] _propagate_visibility_changed()の伝播ロジックが正しいか確認
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
