---
generated_at: 2026-01-23 16:10:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-EditorToaster ERROR

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/gui/editor_toaster.h` 46行目 - SEVERITY_ERROR = 2
- E-02: `editor/gui/editor_toaster.h` 56行目 - error_panel_style_background定義
- E-03: `editor/gui/editor_toaster.cpp` 589-591行目 - error_panel_style_backgroundの初期化
- E-04: `editor/gui/editor_toaster.cpp` 128-130行目 - error_color設定
- E-05: `editor/gui/editor_toaster.cpp` 383-385行目 - SEVERITY_ERROR分岐とスタイル適用
- E-06: `editor/gui/editor_toaster.cpp` 300-301行目 - エラー色インジケーター描画
- E-07: `editor/gui/editor_toaster.cpp` 169-184行目 - _error_handler_impl実装
- E-08: `editor/gui/editor_toaster.cpp` 176-178行目 - INTERNAL ERROR プレフィックス
- E-09: `core/error/error_macros.h` 671-672行目 - ERR_PRINT定義
- E-10: `core/error/error_macros.h` 677-678行目 - ERR_PRINT_ED定義
- E-11: `doc/classes/EditorToaster.xml` 30-32行目 - SEVERITY_ERRORドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SEVERITY_ERRORの値は2である | E-01 | ○ |
| C-02 | 左側にエラー色のボーダーが表示される | E-03, E-04 | ○ |
| C-03 | エラー色はerror_colorテーマ変数から取得される | E-04 | ○ |
| C-04 | error_panel_style_backgroundが使用される | E-02, E-05 | ○ |
| C-05 | set_border_widthでボーダー幅が設定される | E-03 | ○ |
| C-06 | ERR_PRINT_EDマクロでエディタ通知が送信される | E-10 | ○ |
| C-07 | 内部エラーには"INTERNAL ERROR: "プレフィックスが付く | E-08 | ○ |
| C-08 | ERRORは最高の優先度を持つ | E-01 (値2が最大) | ○ |
| C-09 | 通知インジケーターは最高severityの色で表示 | E-06 | ○ |
| C-10 | show_all_setting条件で内部エラー通知が制御される | E-07 (167-169行目) | ○ |
| C-11 | p_editor_notifyがfalseの場合に内部エラー判定される | E-07 (173行目) | ○ |
| C-12 | デフォルトの表示時間は5秒である | editor_toaster.h 91行目 | ○ |
| C-13 | 同時表示上限は5件である | editor_toaster.h 67行目 | ○ |
| C-14 | MessageQueue経由で遅延呼び出しされる | editor_toaster.cpp 447行目 | ○ |
| C-15 | 同一メッセージはカウント表示される | editor_toaster.cpp 520行目 | ○ |
| C-16 | ツールチップにファイル:行番号が表示される | E-07 (171行目) | ○ |
| C-17 | コピーボタンと閉じるボタンが追加される | editor_toaster.cpp 405-420行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] SEVERITY_ERROR=2の確認
- [ ] error_colorがテーマから正しく取得されることの確認
- [ ] 左ボーダーが視覚的に表示されることの確認
- [ ] "INTERNAL ERROR: "プレフィックスが正しく追加されることの確認
- [ ] ERR_PRINT_EDマクロ使用時にエディタ通知が表示されることの確認
