---
generated_at: 2026-01-23 11:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-NOTIFICATION_ENTER_CANVAS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/canvas_item.h` 213行目 - NOTIFICATION_ENTER_CANVAS = 32
- E-02: `scene/main/canvas_item.cpp` 284行目 - notification(NOTIFICATION_ENTER_CANVAS)
- E-03: `scene/main/canvas_item.cpp` 234-285行目 - _enter_canvas関数
- E-04: `scene/main/canvas_item.cpp` 244行目 - canvas_item_set_parent(親CanvasItem)
- E-05: `scene/main/canvas_item.cpp` 269行目 - canvas_item_set_parent(canvas)
- E-06: `scene/main/canvas_item.cpp` 274行目 - add_to_group(canvas_group)
- E-07: `scene/main/canvas_item.cpp` 287-295行目 - _exit_canvas関数
- E-08: `scene/main/canvas_item.cpp` 282行目 - queue_redraw()
- E-09: `scene/main/canvas_item.h` 82-85行目 - canvas_item、canvas_layer、canvas_group

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_ENTER_CANVASの値は32である | E-01 | ○ |
| C-02 | _enter_canvas内でnotification()が呼ばれる | E-02, E-03 | ○ |
| C-03 | NOTIFICATION_ENTER_TREEの処理中に発火する | E-03 | ○ |
| C-04 | 親がCanvasItemの場合、そのcanvas_layerを使用する | E-04 | ○ |
| C-05 | RenderingServer::canvas_item_set_parentで登録される | E-04, E-05 | ○ |
| C-06 | トップレベルの場合、canvas_groupに追加される | E-06 | ○ |
| C-07 | NOTIFICATION_EXIT_CANVASとペアで使用される | E-07 | ○ |
| C-08 | queue_redraw()が呼ばれる | E-08 | ○ |
| C-09 | canvas_item RIDがRenderingServerに登録される | E-09 | ○ |
| C-10 | canvas_layerが設定される | E-03 | ○ |
| C-11 | CanvasLayer/Viewportを検索してキャンバスを取得する | E-03 | ○ |
| C-12 | canvas_item_set_visibility_layerが呼ばれる | E-03 | ○ |
| C-13 | World2D変更時も再度発火する | E-07（WORLD_2D_CHANGEDハンドラ参照） | ○ |
| C-14 | get_parent_item()で親CanvasItemを取得する | E-03 | ○ |
| C-15 | CanvasItem派生クラスで使用される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張にソースコードからの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 通知ID値（32）の正確性 - 低リスク
- 0: _enter_canvas()の処理順序 - 低リスク
- 0: RenderingServer登録処理 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_ENTER_CANVAS = 32 の値が正しいか確認
- [ ] _enter_canvas()の処理フローが正確か確認
- [ ] RenderingServer登録の条件分岐が正しいか確認
- [ ] NOTIFICATION_EXIT_CANVASとのペア関係が正しいか確認
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
