---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-NOTIFICATION_EXIT_CANVAS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **セキュリティ考慮事項**：具体的なコード根拠なし
  2. **派生クラスでの処理詳細**：一部推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/canvas_item.h` 214行目 - NOTIFICATION_EXIT_CANVAS = 33 定義
- E-02: `scene/main/canvas_item.cpp` 287-295行目 - _exit_canvas()メソッド実装
- E-03: `scene/main/canvas_item.cpp` 288行目 - notification(NOTIFICATION_EXIT_CANVAS, true)呼び出し
- E-04: `scene/main/canvas_item.cpp` 289行目 - RenderingServer::canvas_item_set_parent(canvas_item, RID())
- E-05: `scene/main/canvas_item.cpp` 290行目 - canvas_layer = nullptr
- E-06: `scene/main/canvas_item.cpp` 291-294行目 - canvas_group削除処理
- E-07: `scene/main/canvas_item.cpp` 387-393行目 - NOTIFICATION_EXIT_TREEでの_exit_canvas()呼び出し
- E-08: `doc/classes/CanvasItem.xml` 755-759行目 - NOTIFICATION_EXIT_CANVAS公式ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_EXIT_CANVASの値は33である | E-01 | ○ |
| C-02 | この通知はキャンバスから退出する際に発火する | E-02, E-08 | ○ |
| C-03 | 通知は逆順（reverse=true）で送信される | E-03 | ○ |
| C-04 | _exit_canvas()メソッドが通知発行の起点である | E-02 | ○ |
| C-05 | RenderingServerへの親参照解除が行われる | E-04 | ○ |
| C-06 | canvas_layerがnullptrにリセットされる | E-05 | ○ |
| C-07 | canvas_groupからの削除処理が行われる | E-06 | ○ |
| C-08 | NOTIFICATION_EXIT_TREE処理中に発火される | E-07 | ○ |
| C-09 | CanvasItemを継承するすべてのノードが受信者となる | E-01, E-08 | ○ |
| C-10 | 派生クラスで_notification()をオーバーライドして処理可能 | E-08 | ○ |
| C-11 | Light2Dが派生クラスとして通知を処理する | 検索結果より | ○ |
| C-12 | CollisionObject2Dが派生クラスとして通知を処理する | 検索結果より | ○ |
| C-13 | TileMapLayerが派生クラスとして通知を処理する | 検索結果より | ○ |
| C-14 | NOTIFICATION_ENTER_CANVASとペアで使用される | E-01, E-08 | ○ |
| C-15 | 同期処理で即座に発行される | E-03 | ○ |
| C-16 | メインスレッドで処理される | E-07（ERR_MAIN_THREAD_GUARDより推測） | ○ |
| C-17 | セキュリティリスクは外部から直接的にはない | **根拠なし** | △ |
| C-18 | 不適切な実装がクラッシュを引き起こす可能性がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティに関する主張は、コードベースからの直接的な根拠がない
  - 候補：セキュリティ監査ドキュメント / 公式セキュリティガイドライン / 過去のバグレポート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知定数値と基本的な処理フローは十分な根拠あり
- 1: 中リスク - 派生クラスの詳細な処理については網羅的な確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_EXIT_CANVAS = 33 の値が正しいか確認
- [ ] _exit_canvas()の処理順序が正しく記載されているか確認
- [ ] reverse=true の挙動が正しく説明されているか確認
- [ ] 主要な派生クラスでの処理が網羅されているか確認
