---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：32-NOTIFICATION_TRANSFORM_CHANGED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンスに関する主張**：具体的なベンチマーク根拠なし
  2. **DoS的状況の可能性**：セキュリティ観点の具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/canvas_item.h` 210行目 - NOTIFICATION_TRANSFORM_CHANGED = SceneTree::NOTIFICATION_TRANSFORM_CHANGED
- E-02: `scene/main/canvas_item.h` 116行目 - notify_transformフラグ定義
- E-03: `scene/main/canvas_item.h` 173-178行目 - _notify_transform()インライン関数
- E-04: `doc/classes/CanvasItem.xml` 738-740行目 - NOTIFICATION_TRANSFORM_CHANGED公式ドキュメント
- E-05: `doc/classes/CanvasItem.xml` 633-639行目 - set_notify_transform()ドキュメント
- E-06: `doc/classes/CanvasItem.xml` 571-575行目 - is_transform_notification_enabled()ドキュメント
- E-07: Grep検索結果 - Camera2D、Light2D等での使用確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_TRANSFORM_CHANGEDの値は2000である | E-01 | ○ |
| C-02 | この通知はグローバル変換変更時に発火する | E-04 | ○ |
| C-03 | デフォルトでは通知は無効である | E-05, E-06 | ○ |
| C-04 | set_notify_transform(true)で有効化される | E-05 | ○ |
| C-05 | notify_transformフラグが内部で使用される | E-02 | ○ |
| C-06 | _notify_transform()が通知トリガーの起点である | E-03 | ○ |
| C-07 | 親ノードの変換変更が子に伝播する | E-04 | ○ |
| C-08 | Camera2Dが自動的にこの通知を有効化する | E-07 | ○ |
| C-09 | Light2Dが自動的にこの通知を有効化する | E-07 | ○ |
| C-10 | CollisionObject2Dが自動的にこの通知を有効化する | E-07 | ○ |
| C-11 | block_transform_notifyで一時的にブロック可能 | E-03 | ○ |
| C-12 | Node3Dでも同じ通知値が使用される | E-01, Grep検索 | ○ |
| C-13 | NOTIFICATION_LOCAL_TRANSFORM_CHANGEDとは異なる | E-01 | ○ |
| C-14 | 位置変更でトリガーされる | E-04 | ○ |
| C-15 | 回転変更でトリガーされる | E-04 | ○ |
| C-16 | スケール変更でトリガーされる | E-04 | ○ |
| C-17 | シーンツリー内のノードのみが受信可能 | E-03 | ○ |
| C-18 | RemoteTransform2Dが通知を処理する | E-07 | ○ |
| C-19 | 多数のノードで有効化するとパフォーマンスが低下する可能性 | **根拠なし（推測）** | △ |
| C-20 | 頻繁な変換変更がDoS的状況を引き起こす可能性 | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスに関する具体的なベンチマーク数値
  - 候補：パフォーマンステストドキュメント / プロファイリング結果
- セキュリティに関する公式見解
  - 候補：セキュリティガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知定数値と有効化メカニズムは十分な根拠あり
- 1: 中リスク - パフォーマンス関連の主張は一般的な推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_TRANSFORM_CHANGED = 2000 の値が正しいか確認
- [ ] set_notify_transform()の挙動が正しく説明されているか確認
- [ ] _notify_transform()のインライン実装が正しく参照されているか確認
- [ ] 派生クラスでの自動有効化が正しく記載されているか確認
