---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：33-NOTIFICATION_LOCAL_TRANSFORM_CHANGED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **無限ループの可能性**：具体的なコード根拠なし（一般的な注意事項として記載）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/main/canvas_item.h` 215行目 - NOTIFICATION_LOCAL_TRANSFORM_CHANGED = 35定義
- E-02: `scene/main/canvas_item.h` 115行目 - notify_local_transformフラグ定義
- E-03: `scene/main/canvas_item.h` 173-178行目 - _notify_transform()インライン関数（条件チェックと通知発行）
- E-04: `doc/classes/CanvasItem.xml` 742-744行目 - NOTIFICATION_LOCAL_TRANSFORM_CHANGED公式ドキュメント
- E-05: `doc/classes/CanvasItem.xml` 625-631行目 - set_notify_local_transform()ドキュメント
- E-06: `doc/classes/CanvasItem.xml` 565-568行目 - is_local_transform_notification_enabled()ドキュメント
- E-07: Grep検索結果 - Skeleton2D、CollisionShape2D等での使用確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_LOCAL_TRANSFORM_CHANGEDの値は35である | E-01 | ○ |
| C-02 | この通知はローカル変換変更時に発火する | E-03, E-04 | ○ |
| C-03 | 親ノードの変換変更では発火しない | E-04 | ○ |
| C-04 | デフォルトでは通知は無効である | E-05, E-06 | ○ |
| C-05 | set_notify_local_transform(true)で有効化される | E-05 | ○ |
| C-06 | notify_local_transformフラグが内部で使用される | E-02, E-03 | ○ |
| C-07 | _notify_transform()インライン関数内でチェックされる | E-03 | ○ |
| C-08 | block_transform_notifyで一時的にブロック可能 | E-03 | ○ |
| C-09 | is_inside_tree()がtrueの場合のみ発火 | E-03 | ○ |
| C-10 | Bone2Dが自動的にこの通知を有効化する | E-05 | ○ |
| C-11 | CollisionShape2Dが自動的にこの通知を有効化する | E-05, E-07 | ○ |
| C-12 | NOTIFICATION_TRANSFORM_CHANGEDとは異なる | E-01 | ○ |
| C-13 | Node3Dでも同じ通知定数が使用される | E-07 | ○ |
| C-14 | position変更でトリガーされる | E-04 | ○ |
| C-15 | rotation変更でトリガーされる | E-04 | ○ |
| C-16 | scale変更でトリガーされる | E-04 | ○ |
| C-17 | 即座に発火される（遅延なし） | E-03 | ○ |
| C-18 | 無限ループの可能性がある | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- 無限ループの具体的な発生パターンと防止コード
  - 候補：バグレポート / コードレビューコメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知定数値とトリガー条件は十分な根拠あり
- 0: 低リスク - インライン関数の実装から処理フローを正確に追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_LOCAL_TRANSFORM_CHANGED = 35 の値が正しいか確認
- [ ] _notify_transform()インラインの条件チェック順序が正しく説明されているか確認
- [ ] NOTIFICATION_TRANSFORM_CHANGEDとの違いが明確に説明されているか確認
- [ ] 派生クラスでの自動有効化が正しく記載されているか確認
