---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：34-NOTIFICATION_RESIZED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ観点**：悪意のあるスクリプトに関する主張に具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/control.h` 424行目 - NOTIFICATION_RESIZED = 40定義
- E-02: `scene/gui/control.h` 218行目 - size_cacheメンバ変数定義
- E-03: `scene/gui/control.cpp` 1803-1815行目 - _size_changed()メソッド実装
- E-04: `scene/gui/control.cpp` 1812行目 - notification(NOTIFICATION_RESIZED)発行
- E-05: `scene/gui/control.cpp` 3934-3936行目 - NOTIFICATION_RESIZED処理、resizedシグナル発行
- E-06: `scene/gui/control.cpp` 4327行目 - BIND_CONSTANT(NOTIFICATION_RESIZED)
- E-07: Grep検索結果 - Label、TextEdit、ItemList等での使用確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_RESIZEDの値は40である | E-01, E-06 | ○ |
| C-02 | この通知はサイズ変更時に発火する | E-03, E-04 | ○ |
| C-03 | _size_changed()が通知トリガーの起点である | E-03 | ○ |
| C-04 | 通知後にresizedシグナルが発行される | E-05 | ○ |
| C-05 | 同一サイズへの設定では発火しない | E-03 | ○ |
| C-06 | size_cacheがサイズ比較に使用される | E-02, E-03 | ○ |
| C-07 | シーンツリー内のノードのみが受信可能 | E-03 | ○ |
| C-08 | set_size()でトリガーされる | E-03 | ○ |
| C-09 | コンテナのレイアウト更新でトリガーされる | E-03 | ○ |
| C-10 | アンカー変更でもサイズが変化すればトリガーされる | E-03 | ○ |
| C-11 | Labelが通知を処理する | E-07 | ○ |
| C-12 | TextEditが通知を処理する | E-07 | ○ |
| C-13 | ItemListが通知を処理する | E-07 | ○ |
| C-14 | Treeが通知を処理する | E-07 | ○ |
| C-15 | GraphEditが通知を処理する | E-07 | ○ |
| C-16 | Control固有の通知でNode2Dでは使用されない | E-01 | ○ |
| C-17 | _notify_transform()も呼び出される | E-03 | ○ |
| C-18 | item_rect_changed()も呼び出される | E-03 | ○ |
| C-19 | 悪意のあるスクリプトがパフォーマンス問題を引き起こす可能性 | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ/パフォーマンスに関する公式ガイドライン
  - 候補：パフォーマンス最適化ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知定数値と処理フローは十分な根拠あり
- 0: 低リスク - シグナル発行も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_RESIZED = 40 の値が正しいか確認
- [ ] _size_changed()の処理順序が正しく説明されているか確認
- [ ] resizedシグナルとの関係が正しく説明されているか確認
- [ ] 主要な派生クラスでの処理が網羅されているか確認
