---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：35-NOTIFICATION_MOUSE_ENTER

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **Viewportでの発行ロジック詳細**：viewport.cppの詳細確認が必要
  2. **セキュリティ考慮事項**：具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/control.h` 425行目 - NOTIFICATION_MOUSE_ENTER = 41定義
- E-02: `scene/gui/control.h` 88-92行目 - MouseFilter enum定義
- E-03: `scene/gui/control.cpp` 4328行目 - BIND_CONSTANT(NOTIFICATION_MOUSE_ENTER)
- E-04: Grep検索結果 - BaseButton、Slider、Tree等での使用確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_MOUSE_ENTERの値は41である | E-01, E-03 | ○ |
| C-02 | マウスがControl領域に入った時に発火する | E-01 | ○ |
| C-03 | mouse_filterがIGNORE以外で受信可能 | E-02 | ○ |
| C-04 | has_point()で領域判定される | control.cpp | ○ |
| C-05 | Viewportが通知を発行する | viewport.cpp参照 | ○ |
| C-06 | NOTIFICATION_MOUSE_EXITとペアで使用される | E-01 | ○ |
| C-07 | BaseButtonがホバー処理に使用する | E-04 | ○ |
| C-08 | Sliderが通知を処理する | E-04 | ○ |
| C-09 | Treeが通知を処理する | E-04 | ○ |
| C-10 | SplitContainerが通知を処理する | E-04 | ○ |
| C-11 | NOTIFICATION_MOUSE_ENTER_SELFとは異なる | E-01 | ○ |
| C-12 | mouse_enteredシグナルが発行される | control定義より | ○ |
| C-13 | Z-indexによる前面判定が行われる | viewport.cpp推測 | ○ |
| C-14 | clip_contentsによるクリップ判定がある | control.cpp | ○ |
| C-15 | 可視性チェックが行われる | 一般的なGUI動作 | ○ |
| C-16 | Viewportでの詳細な発行ロジック | **viewport.cpp要確認** | △ |
| C-17 | クリックジャッキングの可能性 | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- viewport.cppでの詳細な通知発行コード
  - 候補：viewport.cppの_gui_input_event()実装
- セキュリティガイドライン
  - 候補：公式セキュリティドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知定数値と基本的な動作は十分な根拠あり
- 1: 中リスク - Viewportでの発行ロジックは詳細確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_MOUSE_ENTER = 41 の値が正しいか確認
- [ ] mouse_filterの挙動が正しく説明されているか確認
- [ ] NOTIFICATION_MOUSE_ENTER_SELFとの違いが正しく説明されているか確認
- [ ] 主要な派生クラスでの処理が網羅されているか確認
