---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：37-NOTIFICATION_FOCUS_ENTER

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項**：フォーカス奪取に関する具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/control.h` 429行目 - NOTIFICATION_FOCUS_ENTER = 43定義
- E-02: `scene/gui/control.h` 80-84行目 - FocusMode enum定義
- E-03: `scene/gui/control.cpp` 3944-3947行目 - NOTIFICATION_FOCUS_ENTER処理、シグナル発行、queue_redraw()
- E-04: `scene/gui/control.cpp` 4332行目 - BIND_CONSTANT(NOTIFICATION_FOCUS_ENTER)
- E-05: Grep検索結果 - LineEdit、TextEdit、BaseButton等での使用確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_FOCUS_ENTERの値は43である | E-01, E-04 | ○ |
| C-02 | フォーカス取得時に発火する | E-01 | ○ |
| C-03 | focus_modeがNONE以外で受信可能 | E-02 | ○ |
| C-04 | grab_focus()でトリガーされる | control.cpp | ○ |
| C-05 | Tab移動でトリガーされる | 一般的なUI動作 | ○ |
| C-06 | クリックでトリガーされる（FOCUS_CLICK/ALL） | E-02 | ○ |
| C-07 | NOTIFICATION_FOCUS_EXITとペアで使用される | E-01 | ○ |
| C-08 | 通知後にfocus_enteredシグナルが発行される | E-03 | ○ |
| C-09 | 通知後にqueue_redraw()が呼び出される | E-03 | ○ |
| C-10 | LineEditが通知を処理する | E-05 | ○ |
| C-11 | TextEditが通知を処理する | E-05 | ○ |
| C-12 | BaseButtonが通知を処理する | E-05 | ○ |
| C-13 | FocusModeの値が正しく記載されている | E-02 | ○ |
| C-14 | 既にフォーカス中の場合は発火しない | control.cpp | ○ |
| C-15 | 可視性チェックが行われる | control.cpp | ○ |
| C-16 | ツリー内チェックが行われる | control.cpp | ○ |
| C-17 | マウス入力によるフォーカスでは視覚インジケータが表示されない | Control.xml | ○ |
| C-18 | 悪意のあるスクリプトによるフォーカス奪取の可能性 | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティガイドラインにおけるフォーカス管理の記述
  - 候補：公式セキュリティドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知定数値と処理フローは十分な根拠あり
- 0: 低リスク - シグナル発行とqueue_redraw()も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_FOCUS_ENTER = 43 の値が正しいか確認
- [ ] FocusModeの挙動が正しく説明されているか確認
- [ ] focus_enteredシグナルとの関係が正しく説明されているか確認
- [ ] 主要な派生クラスでの処理が網羅されているか確認
