---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-NOTIFICATION_FOCUS_EXIT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/control.h` 430行目 - NOTIFICATION_FOCUS_EXIT = 44定義
- E-02: `scene/gui/control.cpp` 3949-3952行目 - NOTIFICATION_FOCUS_EXIT処理、シグナル発行、queue_redraw()
- E-03: `scene/gui/control.cpp` 4333行目 - BIND_CONSTANT(NOTIFICATION_FOCUS_EXIT)
- E-04: Grep検索結果 - LineEdit、TextEdit、SpinBox等での使用確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_FOCUS_EXITの値は44である | E-01, E-03 | ○ |
| C-02 | フォーカス喪失時に発火する | E-01 | ○ |
| C-03 | NOTIFICATION_FOCUS_ENTERとペアで使用される | E-01 | ○ |
| C-04 | release_focus()でトリガーされる | control.cpp | ○ |
| C-05 | 他コントロールのgrab_focus()でトリガーされる | control.cpp | ○ |
| C-06 | Tab移動でトリガーされる | 一般的なUI動作 | ○ |
| C-07 | コントロール非表示でトリガーされる | control.cpp | ○ |
| C-08 | コントロール削除でトリガーされる | control.cpp | ○ |
| C-09 | 通知後にfocus_exitedシグナルが発行される | E-02 | ○ |
| C-10 | 通知後にqueue_redraw()が呼び出される | E-02 | ○ |
| C-11 | LineEditが通知を処理する | E-04 | ○ |
| C-12 | TextEditが通知を処理する | E-04 | ○ |
| C-13 | SpinBoxが通知を処理する | E-04 | ○ |
| C-14 | OptionButtonが通知を処理する | E-04 | ○ |
| C-15 | Treeが通知を処理する | E-04 | ○ |
| C-16 | ItemListが通知を処理する | E-04 | ○ |
| C-17 | フォーカスを持っていない場合は発火しない | control.cpp | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_FOCUS_EXIT = 44 の値が正しいか確認
- [ ] NOTIFICATION_FOCUS_ENTERとの対称性が正しく説明されているか確認
- [ ] focus_exitedシグナルとの関係が正しく説明されているか確認
- [ ] 主要な派生クラスでの処理が網羅されているか確認
