---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-NOTIFICATION_THEME_CHANGED

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/control.h` 431行目 - NOTIFICATION_THEME_CHANGED = 45定義
- E-02: `scene/gui/control.cpp` 2932-2936行目 - _notify_theme_override_changed()メソッド
- E-03: `scene/gui/control.cpp` 3013-3017行目 - set_theme_type_variation()メソッド
- E-04: `scene/gui/control.cpp` 3954-3963行目 - NOTIFICATION_THEME_CHANGED処理
- E-05: `scene/gui/control.cpp` 4334行目 - BIND_CONSTANT(NOTIFICATION_THEME_CHANGED)
- E-06: `scene/gui/control.cpp` 3030行目等 - 早期アクセス警告（WARN_PRINT_ONCE）
- E-07: Grep検索結果 - Label、Button、Tree等での使用確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_THEME_CHANGEDの値は45である | E-01, E-05 | ○ |
| C-02 | テーマ変更時に発火する | E-02, E-03 | ○ |
| C-03 | set_theme()でトリガーされる | E-03 | ○ |
| C-04 | set_theme_type_variation()でトリガーされる | E-03 | ○ |
| C-05 | add_theme_*_override()でトリガーされる | E-02 | ○ |
| C-06 | remove_theme_*_override()でトリガーされる | E-02 | ○ |
| C-07 | bulk_theme_override中は通知が遅延される | E-02 | ○ |
| C-08 | begin_bulk_theme_override()でバッチモード開始 | control.cpp | ○ |
| C-09 | end_bulk_theme_override()でバッチモード終了 | control.cpp | ○ |
| C-10 | 通知後にtheme_changedシグナルが発行される | E-04 | ○ |
| C-11 | 通知後に_invalidate_theme_cache()が呼び出される | E-04 | ○ |
| C-12 | 通知後にupdate_minimum_size()が呼び出される | E-04 | ○ |
| C-13 | 早期アクセス時に警告が出力される | E-06 | ○ |
| C-14 | Labelが通知を処理する | E-07 | ○ |
| C-15 | Buttonが通知を処理する | E-07 | ○ |
| C-16 | Treeが通知を処理する | E-07 | ○ |
| C-17 | TextEditが通知を処理する | E-07 | ○ |
| C-18 | シーンツリー内のノードのみが受信可能 | E-02 | ○ |
| C-19 | 親テーマ変更が子に伝播する | theme_owner.cpp | ○ |
| C-20 | ENTER_TREEでテーマコンテキストが設定される | control.cpp 3839-3841行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] NOTIFICATION_THEME_CHANGED = 45 の値が正しいか確認
- [ ] bulk_theme_overrideの動作が正しく説明されているか確認
- [ ] theme_changedシグナルとの関係が正しく説明されているか確認
- [ ] _invalidate_theme_cache()とupdate_minimum_size()の呼び出し順序が正しいか確認
