---
generated_at: 2026-01-23 16:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-push_error

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/variant/variant_utility.h` 140行目 - push_error関数シグネチャ
- E-02: `core/variant/variant_utility.cpp` 1018-1026行目 - push_error実装
- E-03: `core/variant/variant_utility.cpp` 1019-1022行目 - 引数数チェック
- E-04: `core/variant/variant_utility.cpp` 1024行目 - ERR_PRINT呼び出し
- E-05: `core/error/error_macros.h` 671-672行目 - ERR_PRINTマクロ定義
- E-06: `core/error/error_macros.cpp` 106-135行目 - _err_print_error実装
- E-07: `core/error/error_macros.cpp` 107-112行目 - 再帰呼び出し防止
- E-08: `core/os/os.cpp` 97-105行目 - OS::print_error実装
- E-09: `core/io/logger.cpp` 58-80行目 - Logger::log_error実装
- E-10: `core/io/logger.h` 50-55行目 - ErrorType列挙型（ERR_ERROR）
- E-11: `core/variant/variant_utility.cpp` 1761行目 - FUNCBINDVARARGV(push_error)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | push_errorは可変長引数を受け取る | E-01, E-02 | ○ |
| C-02 | 引数はjoin_string関数で連結される | E-04 | ○ |
| C-03 | 引数が1つ未満の場合エラーが設定される | E-03 | ○ |
| C-04 | ERR_PRINTマクロが内部で呼び出される | E-04, E-05 | ○ |
| C-05 | _err_print_error関数でエラー出力される | E-05, E-06 | ○ |
| C-06 | 再帰呼び出しはフォールバック出力に切り替わる | E-07 | ○ |
| C-07 | OS::print_errorを通じてLoggerに通知される | E-08 | ○ |
| C-08 | Logger::log_errorでフォーマット出力される | E-09 | ○ |
| C-09 | 出力形式は "ERROR: {message}" + 位置情報 | E-09 (72-73行目) | ○ |
| C-10 | スクリプトバックトレースが出力される | E-09 (75-79行目) | ○ |
| C-11 | ErrorHandlerListに通知が伝播する | E-06 (124-130行目) | ○ |
| C-12 | @GlobalScope関数として登録されている | E-11 | ○ |
| C-13 | エラー出力後も実行は継続される | E-02 (returnなし) | ○ |
| C-14 | CoreGlobals::print_error_enabledで制御される | logger.cpp 50-52行目 | ○ |
| C-15 | CallError::CALL_OKが設定される | E-02 (1025行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] push_errorが可変長引数を正しく処理することの確認
- [ ] ERR_PRINTマクロとの同等性の確認
- [ ] スクリプトバックトレースが正しく出力されることの確認
- [ ] エラー出力後にプログラムが継続することの確認
